package net.java.otr4j;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

import net.java.otr4j.crypto.KeyAndSession;
import net.java.otr4j.session.SessionID;

import com.beem.project.beem.service.ChatAdapter;


public class OtrEngineHostImpl implements OtrEngineHost{
	
	private ChatAdapter mChat;
	private OtrPolicy policy;
    public String lastInjectedMessage;
    private ArrayList<KeyAndSession> keyring = new ArrayList<KeyAndSession>();
    
	public OtrEngineHostImpl(ChatAdapter chat, OtrPolicy policy){
		mChat = chat;
		this.policy = policy;
	}
	
	@Override
	public KeyPair getKeyPair(SessionID sessionID) {
		 
		for(int i = 0; i<keyring.size(); i++){
			if(sessionID.equals(keyring.get(i).getSessionID())){
				return keyring.get(i).getKeyPair();
			}
		}
		
		 KeyPairGenerator kg;
         try {
                 kg = KeyPairGenerator.getInstance("DSA");

         } catch (NoSuchAlgorithmException e) {
                 e.printStackTrace();
                 return null;
         }
         KeyAndSession kp = new KeyAndSession(kg.genKeyPair(), sessionID);
         keyring.add(kp);
         return kp.getKeyPair();
	}

	@Override
	public OtrPolicy getSessionPolicy(SessionID sessionID) {
		return this.policy;
	}

	@Override
	public void injectMessage(SessionID sessionID, String msg) {
		mChat.sendMessage(msg);
	}

	@Override
	public void showError(SessionID sessionID, String error) {
	//	mChat.otrStatusDisplay.setText(""+error);		
	}

	@Override
	public void showWarning(SessionID sessionID, String warning) {
		//mChat.otrStatusDisplay.setText(""+warning);
	}

}
