/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import com.sun.security.sasl.CramMD5Base;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import security.javax.security.sasl.SaslClient;
import security.javax.security.sasl.SaslException;

final class CramMD5Client
extends CramMD5Base
implements SaslClient {
    private String username;

    CramMD5Client(String authID, byte[] pw) throws SaslException {
        if (authID == null || pw == null) {
            throw new SaslException("CRAM-MD5: authentication ID and password must be specified");
        }
        this.username = authID;
        this.pw = pw;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 authentication already completed");
        }
        if (this.aborted) {
            throw new IllegalStateException("CRAM-MD5 authentication previously aborted due to error");
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "CRAMCLNT01:Received challenge: {0}", new String(challengeData, "UTF8"));
            }
            String digest = CramMD5Client.HMAC_MD5(this.pw, challengeData);
            this.clearPassword();
            String resp = String.valueOf(this.username) + " " + digest;
            logger.log(Level.FINE, "CRAMCLNT02:Sending response: {0}", resp);
            this.completed = true;
            return resp.getBytes("UTF8");
        }
        catch (NoSuchAlgorithmException e) {
            this.aborted = true;
            throw new SaslException("MD5 algorithm not available on platform", e);
        }
        catch (UnsupportedEncodingException e) {
            this.aborted = true;
            throw new SaslException("UTF8 not available on platform", e);
        }
    }
}

