

/**
extern gsm  gsm_create 	GSMJNI_P((void));
extern void gsm_destroy GSMJNI_P((gsm));	

extern int  gsm_print   GSMJNI_P((FILE *, gsm, gsm_byte  *));
extern int  gsm_option  GSMJNI_P((gsm, int, int *));

extern void gsm_encode  GSMJNI_P((gsm, gsm_signal *, gsm_byte  *));
extern int  gsm_decode  GSMJNI_P((gsm, gsm_byte   *, gsm_signal *));

extern int  gsm_explode GSMJNI_P((gsm, gsm_byte   *, gsm_signal *));
extern void gsm_implode GSMJNI_P((gsm, gsm_signal *, gsm_byte   *));
*/


#include <jni.h>


#include "gsm.h"
#include "private.h"
#include "proto.h"

jlong
Java_org_sipdroid_media_codecs_GSMJNI_create(JNIEnv *env)
{
	return gsm_create();
}

void
Java_org_sipdroid_media_codecs_GSMJNI_destroy(JNIEnv *env, jlong jgsm)
{
	gsm_destroy((void *)jgsm);
}

void
Java_org_sipdroid_media_codecs_GSMJNI_encode(JNIEnv *env, jlong jgsm, jshortArray jgsmSignal, jlong jsrcPos, jbyteArray jgsmByte, jlong jdestPos)
{
	jshort *gsmSignal;
	jbyte *gsmByte;
	jboolean isCopyByte;
	jboolean isCopySignal;
	void *ctx = (void *) jgsm;

	gsmByte = (*env)->GetByteArrayElements( env, jgsmByte, &isCopyByte);
	gsmSignal = (*env)->GetShortArrayElements( env, jgsmSignal, &isCopySignal);
	
	gsm_encode(ctx, gsmSignal + jsrcPos, gsmByte + jdestPos);
	if (isCopyByte == JNI_TRUE)
		(*env)->ReleaseByteArrayElements(env, jgsmByte, gsmByte,0);
	if (isCopySignal == JNI_TRUE)
		(*env)->ReleaseShortArrayElements(env, jgsmSignal, gsmSignal,0);
}

jint
Java_org_sipdroid_media_codecs_GSMJNI_decode(JNIEnv *env, jlong jgsm, jbyteArray jgsmByte, jlong jdestPos, jshortArray jgsmSignal, jlong jsrcPos)
{
	jshort *gsmSignal;
	jbyte *gsmByte;
	jboolean isCopyByte;
	jboolean isCopySignal;
	jint res;

	gsmSignal = (*env)->GetShortArrayElements( env, jgsmSignal, &isCopySignal);
	gsmByte = (*env)->GetByteArrayElements( env, jgsmByte, &isCopyByte);
	res = gsm_decode((void *)jgsm, gsmByte + jdestPos, gsmSignal + jsrcPos);
	if (isCopyByte == JNI_TRUE)
		(*env)->ReleaseByteArrayElements(env, jgsmByte, gsmByte,0);
	if (isCopySignal == JNI_TRUE)
		(*env)->ReleaseShortArrayElements(env, jgsmSignal, gsmSignal,0);
	return res;
}

jint
Java_org_sipdroid_media_codecs_GSMJNI_option(JNIEnv *env, jlong jgsm, jint jopt, jintArray jval)
{
	jint *val;
	jboolean isCopyVal;
	jint res;

	val = (*env)->GetIntArrayElements( env, jval, &isCopyVal);
	res = gsm_option((void *)jgsm, jopt, val);
	if (isCopyVal == JNI_TRUE)
		(*env)->ReleaseIntArrayElements(env, jval, val,0);
	return res;
}
