
package com.beem.project.beem.service;

import android.os.Parcel;
import android.os.Parcelable;
import org.jivesoftware.smack.util.StringUtils;

/**
 * This class contains information about the user of the connection.
 * These informations are sent by the connection.
 *
 */
public class UserInfo implements Parcelable {

    /** Parcelable.Creator needs by Android. */
    public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>() {

	@Override
	public UserInfo createFromParcel(Parcel source) {
	    return new UserInfo(source);
	}

	@Override
	public UserInfo[] newArray(int size) {
	    return new UserInfo[size];
	}
    };

    private final String mBareJid;
    private String mAvatarId;

    /**
     * Construct a UserInfo from a parcel.
     * @param in parcel to use for construction
     */
    private UserInfo(final Parcel in) {
	mBareJid= in.readString();
	mAvatarId = in.readString();
    }

    /**
     * Constructor.
     * @param jid jid of the user
     */
    public UserInfo(final String jid) {
	mBareJid = StringUtils.parseBareAddress(jid);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
	dest.writeString(mBareJid);
	dest.writeString(mAvatarId);
    }

    @Override
    public int describeContents() {
	return 0;
    }

    public String getAvatarId() {
	return mAvatarId;
    }

    public void setAvatarId(String avatarId) {
	mAvatarId = avatarId;
    }

    public String getJid() {
	return mBareJid;
    }
}
