package com.beem.project.beem;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

import android.content.ContentValues;
import android.content.Context;
import android.util.Log;

import com.beem.project.beem.providers.Messages;

public class BeemPacketListener implements PacketListener {

    private static final String TAG = BeemPacketListener.class.getName();
    private Context mContext;
    private XMPPConnection mXMPPConnection;

    public BeemPacketListener(Context c, XMPPConnection connection) {
	mContext = c;
	mXMPPConnection = connection;
    }

    @Override
    public void processPacket(Packet packet) {
	if (packet instanceof Presence) {
	    Presence pres = (Presence) packet;
	    if (pres.getType() == Presence.Type.subscribe) {
		//TODO: Notification on receive presence subscribe
//		String from = packet.getFrom();
//		Notification notif = new Notification(android.R.drawable.stat_notify_more, mService.getString(
//		    R.string.AcceptContactRequest, from), System.currentTimeMillis());
//		notif.flags = Notification.FLAG_AUTO_CANCEL;
//		Intent intent = new Intent(mService, Subscription.class);
//		intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK).putExtra("from", from);
//		notif.setLatestEventInfo(mService, from, mService.getString(R.string.AcceptContactRequestFrom, from),
//		    PendingIntent.getActivity(mService, 0, intent, PendingIntent.FLAG_ONE_SHOT));
//		int id = packet.hashCode();
//		mService.sendNotification(id, notif);
//		Presence p = (Presence) packet;
//		updateNotification(Status.getStatusFromPresence(p), p.getStatus());
	    }
	} else if (packet instanceof Message) {
	    Message msg = (Message) packet;
	    if (msg.getType() == Message.Type.error) {
		;
	    } else if (msg.getBody() != null) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		ContentValues values = new ContentValues();
		values.put(Messages.FROM, msg.getFrom());
		values.put(Messages.MESSAGE_ID, msg.getPacketID());
		values.put(Messages.TO, msg.getTo());
		values.put(Messages.TYPE, Message.Type.chat.toString());
		values.put(Messages.SUBJECT, msg.getSubject());
		values.put(Messages.BODY, msg.getBody());
		values.put(Messages.THREAD, msg.getThread());
		values.put(Messages.EXTRAS, "");
		values.put(Messages.IS_RECEIVE, true);
		values.put(Messages.DATE_RECEIVE, dateFormat.format(new Date()));
		values.put(Messages.DATE_READ, dateFormat.format(new Date()));
		mContext.getContentResolver().insert(Messages.CONTENT_URI, values);
	    } else {
		Log.w(TAG, "Unknow Message packet (body null): " + msg.getType());
	    }
	} else if (packet instanceof PingExtension) {
	    PingExtension p = (PingExtension) packet;
	    if (p.getType() == IQ.Type.GET) {
		PingExtension pong = new PingExtension();
		pong.setType(IQ.Type.RESULT);
		pong.setTo(p.getFrom());
		pong.setPacketID(p.getPacketID());
		mXMPPConnection.sendPacket(pong);
	    } else {
		Log.w(TAG, "Unknow PingExtension packet : " + packet.getClass().toString());
	    }

	}
    }

    public class PingExtension extends IQ {

	/** Namespace of the Ping XEP. */
	public static final String NAMESPACE = "urn:xmpp:ping";

	/** Xml element name for the ping. */
	public static final String ELEMENT = "ping";

	/**
	 * Create a ping iq packet.
	 */
	public PingExtension() {
	}

	@Override
	public String getChildElementXML() {
	    if (getType() == IQ.Type.RESULT)
		return null;
	    return "<" + ELEMENT + " xmlns=\"" + NAMESPACE + "\" />";
	}

    }
}
