/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.tests;

import java.util.Iterator;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.ZoneTransferIn;

public class xfrin {
    private static void usage(String string) {
        System.out.println("Error: " + string);
        System.out.println("usage: xfrin [-i serial] [-k keyname/secret] [-s server] [-p port] [-f] zone");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        TSIG tSIG = null;
        int n2 = -1;
        String string = null;
        int n3 = 53;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-i")) {
                if ((n2 = Integer.parseInt(stringArray[++n])) >= 0) continue;
                xfrin.usage("invalid serial number");
                continue;
            }
            if (stringArray[n].equals("-k")) {
                int n4;
                if ((n4 = ((String)(object = stringArray[++n])).indexOf(47)) < 0) {
                    xfrin.usage("invalid key");
                }
                tSIG = new TSIG(((String)object).substring(0, n4), ((String)object).substring(n4 + 1));
                continue;
            }
            if (stringArray[n].equals("-s")) {
                string = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-p")) {
                if ((n3 = Integer.parseInt(stringArray[++n])) >= 0 && n3 <= 65535) continue;
                xfrin.usage("invalid port");
                continue;
            }
            if (stringArray[n].equals("-f")) {
                bl = true;
                continue;
            }
            if (!stringArray[n].startsWith("-")) break;
            xfrin.usage("invalid option");
        }
        if (n >= stringArray.length) {
            xfrin.usage("no zone name specified");
        }
        Name name = Name.fromString(stringArray[n]);
        if (string == null) {
            object = new Lookup(name, 2);
            Record[] recordArray = ((Lookup)object).run();
            if (recordArray == null) {
                System.out.println("failed to look up NS record: " + ((Lookup)object).getErrorString());
                System.exit(1);
            }
            string = recordArray[0].rdataToString();
            System.out.println("sending to server '" + string + "'");
        }
        ZoneTransferIn zoneTransferIn = n2 >= 0 ? ZoneTransferIn.newIXFR(name, n2, bl, string, n3, tSIG) : ZoneTransferIn.newAXFR(name, string, n3, tSIG);
        object = zoneTransferIn.run();
        if (zoneTransferIn.isAXFR()) {
            if (n2 >= 0) {
                System.out.println("AXFR-like IXFR response");
            } else {
                System.out.println("AXFR response");
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        } else if (zoneTransferIn.isIXFR()) {
            System.out.println("IXFR response");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ZoneTransferIn.Delta delta = (ZoneTransferIn.Delta)iterator.next();
                System.out.println("delta from " + delta.start + " to " + delta.end);
                System.out.println("deletes");
                Iterator iterator2 = delta.deletes.iterator();
                while (iterator2.hasNext()) {
                    System.out.println(iterator2.next());
                }
                System.out.println("adds");
                iterator2 = delta.adds.iterator();
                while (iterator2.hasNext()) {
                    System.out.println(iterator2.next());
                }
            }
        } else if (zoneTransferIn.isCurrent()) {
            System.out.println("up to date");
        }
    }
}

