/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.WireParseException;

final class TypeBitmap
implements Serializable {
    private static final long serialVersionUID = -125354057735389003L;
    private TreeSet types = new TreeSet();

    private TypeBitmap() {
    }

    public TypeBitmap(int[] nArray) {
        this();
        for (int i = 0; i < nArray.length; ++i) {
            Type.check(nArray[i]);
            this.types.add(new Integer(nArray[i]));
        }
    }

    public TypeBitmap(DNSInput dNSInput) throws WireParseException {
        this();
        int n = -1;
        while (dNSInput.remaining() > 0) {
            if (dNSInput.remaining() < 2) {
                throw new WireParseException("invalid bitmap descriptor");
            }
            int n2 = dNSInput.readU8();
            if (n2 < n) {
                throw new WireParseException("invalid ordering");
            }
            int n3 = dNSInput.readU8();
            if (n3 > dNSInput.remaining()) {
                throw new WireParseException("invalid bitmap");
            }
            for (int i = 0; i < n3; ++i) {
                int n4 = dNSInput.readU8();
                if (n4 == 0) continue;
                for (int j = 0; j < 8; ++j) {
                    if ((n4 & 1 << 7 - j) == 0) continue;
                    int n5 = n2 * 256 + i * 8 + j;
                    this.types.add(Mnemonic.toInteger(n5));
                }
            }
        }
    }

    public TypeBitmap(Tokenizer tokenizer) throws IOException {
        this();
        Tokenizer.Token token;
        while ((token = tokenizer.get()).isString()) {
            int n = Type.value(token.value);
            if (n < 0) {
                throw tokenizer.exception("Invalid type: " + token.value);
            }
            this.types.add(Mnemonic.toInteger(n));
        }
        tokenizer.unget();
    }

    public int[] toArray() {
        int[] nArray = new int[this.types.size()];
        int n = 0;
        Iterator iterator = this.types.iterator();
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.types.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            stringBuffer.append(Type.string(n));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static void mapToWire(DNSOutput dNSOutput, TreeSet treeSet, int n) {
        int n2 = (Integer)treeSet.last() & 0xFF;
        int n3 = n2 / 8 + 1;
        int[] nArray = new int[n3];
        dNSOutput.writeU8(n);
        dNSOutput.writeU8(n3);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            int n5 = (n4 & 0xFF) / 8;
            nArray[n5] = nArray[n5] | 1 << 7 - n4 % 8;
        }
        for (int i = 0; i < n3; ++i) {
            dNSOutput.writeU8(nArray[i]);
        }
    }

    public void toWire(DNSOutput dNSOutput) {
        if (this.types.size() == 0) {
            return;
        }
        int n = -1;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.types.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            int n3 = n2 >> 8;
            if (n3 != n) {
                if (treeSet.size() > 0) {
                    TypeBitmap.mapToWire(dNSOutput, treeSet, n);
                    treeSet.clear();
                }
                n = n3;
            }
            treeSet.add(new Integer(n2));
        }
        TypeBitmap.mapToWire(dNSOutput, treeSet, n);
    }

    public boolean empty() {
        return this.types.isEmpty();
    }

    public boolean contains(int n) {
        return this.types.contains(Mnemonic.toInteger(n));
    }
}

