/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.security.PublicKey;
import java.util.StringTokenizer;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class KEYRecord
extends KEYBase {
    private static final long serialVersionUID = 6385613447571488906L;
    public static final int FLAG_NOCONF = 16384;
    public static final int FLAG_NOAUTH = 32768;
    public static final int FLAG_NOKEY = 49152;
    public static final int OWNER_ZONE = 256;
    public static final int OWNER_HOST = 512;
    public static final int OWNER_USER = 0;
    public static final int PROTOCOL_TLS = 1;
    public static final int PROTOCOL_EMAIL = 2;
    public static final int PROTOCOL_DNSSEC = 3;
    public static final int PROTOCOL_IPSEC = 4;
    public static final int PROTOCOL_ANY = 255;

    KEYRecord() {
    }

    @Override
    Record getObject() {
        return new KEYRecord();
    }

    public KEYRecord(Name name, int n, long l, int n2, int n3, int n4, byte[] byArray) {
        super(name, 25, n, l, n2, n3, n4, byArray);
    }

    public KEYRecord(Name name, int n, long l, int n2, int n3, int n4, PublicKey publicKey) throws DNSSEC.DNSSECException {
        super(name, 25, n, l, n2, n3, n4, DNSSEC.fromPublicKey(publicKey, n4));
        this.publicKey = publicKey;
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getIdentifier();
        this.flags = Flags.value(string);
        if (this.flags < 0) {
            throw tokenizer.exception("Invalid flags: " + string);
        }
        String string2 = tokenizer.getIdentifier();
        this.proto = Protocol.value(string2);
        if (this.proto < 0) {
            throw tokenizer.exception("Invalid protocol: " + string2);
        }
        String string3 = tokenizer.getIdentifier();
        this.alg = DNSSEC.Algorithm.value(string3);
        if (this.alg < 0) {
            throw tokenizer.exception("Invalid algorithm: " + string3);
        }
        this.key = (byte[])((this.flags & 0xC000) == 49152 ? null : tokenizer.getBase64());
    }

    public static class Flags {
        public static final int NOCONF = 16384;
        public static final int NOAUTH = 32768;
        public static final int NOKEY = 49152;
        public static final int USE_MASK = 49152;
        public static final int FLAG2 = 8192;
        public static final int EXTEND = 4096;
        public static final int FLAG4 = 2048;
        public static final int FLAG5 = 1024;
        public static final int USER = 0;
        public static final int ZONE = 256;
        public static final int HOST = 512;
        public static final int NTYP3 = 768;
        public static final int OWNER_MASK = 768;
        public static final int FLAG8 = 128;
        public static final int FLAG9 = 64;
        public static final int FLAG10 = 32;
        public static final int FLAG11 = 16;
        public static final int SIG0 = 0;
        public static final int SIG1 = 1;
        public static final int SIG2 = 2;
        public static final int SIG3 = 3;
        public static final int SIG4 = 4;
        public static final int SIG5 = 5;
        public static final int SIG6 = 6;
        public static final int SIG7 = 7;
        public static final int SIG8 = 8;
        public static final int SIG9 = 9;
        public static final int SIG10 = 10;
        public static final int SIG11 = 11;
        public static final int SIG12 = 12;
        public static final int SIG13 = 13;
        public static final int SIG14 = 14;
        public static final int SIG15 = 15;
        private static Mnemonic flags = new Mnemonic("KEY flags", 2);

        private Flags() {
        }

        public static int value(String string) {
            try {
                int n = Integer.parseInt(string);
                if (n >= 0 && n <= 65535) {
                    return n;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    int n2 = flags.getValue(stringTokenizer.nextToken());
                    if (n2 < 0) {
                        return -1;
                    }
                    n |= n2;
                }
                return n;
            }
        }

        static {
            flags.setMaximum(65535);
            flags.setNumericAllowed(false);
            flags.add(16384, "NOCONF");
            flags.add(32768, "NOAUTH");
            flags.add(49152, "NOKEY");
            flags.add(8192, "FLAG2");
            flags.add(4096, "EXTEND");
            flags.add(2048, "FLAG4");
            flags.add(1024, "FLAG5");
            flags.add(0, "USER");
            flags.add(256, "ZONE");
            flags.add(512, "HOST");
            flags.add(768, "NTYP3");
            flags.add(128, "FLAG8");
            flags.add(64, "FLAG9");
            flags.add(32, "FLAG10");
            flags.add(16, "FLAG11");
            flags.add(0, "SIG0");
            flags.add(1, "SIG1");
            flags.add(2, "SIG2");
            flags.add(3, "SIG3");
            flags.add(4, "SIG4");
            flags.add(5, "SIG5");
            flags.add(6, "SIG6");
            flags.add(7, "SIG7");
            flags.add(8, "SIG8");
            flags.add(9, "SIG9");
            flags.add(10, "SIG10");
            flags.add(11, "SIG11");
            flags.add(12, "SIG12");
            flags.add(13, "SIG13");
            flags.add(14, "SIG14");
            flags.add(15, "SIG15");
        }
    }

    public static class Protocol {
        public static final int NONE = 0;
        public static final int TLS = 1;
        public static final int EMAIL = 2;
        public static final int DNSSEC = 3;
        public static final int IPSEC = 4;
        public static final int ANY = 255;
        private static Mnemonic protocols = new Mnemonic("KEY protocol", 2);

        private Protocol() {
        }

        public static String string(int n) {
            return protocols.getText(n);
        }

        public static int value(String string) {
            return protocols.getValue(string);
        }

        static {
            protocols.setMaximum(255);
            protocols.setNumericAllowed(true);
            protocols.add(0, "NONE");
            protocols.add(1, "TLS");
            protocols.add(2, "EMAIL");
            protocols.add(3, "DNSSEC");
            protocols.add(4, "IPSEC");
            protocols.add(255, "ANY");
        }
    }
}

