/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class ARecord
extends Record {
    private static final long serialVersionUID = -2172609200849142323L;
    private int addr;

    ARecord() {
    }

    @Override
    Record getObject() {
        return new ARecord();
    }

    private static final int fromArray(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static final byte[] toArray(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public ARecord(Name name, int n, long l, InetAddress inetAddress) {
        super(name, 1, n, l);
        if (Address.familyOf(inetAddress) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(inetAddress.getAddress());
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.addr = ARecord.fromArray(dNSInput.readByteArray(4));
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        InetAddress inetAddress = tokenizer.getAddress(1);
        this.addr = ARecord.fromArray(inetAddress.getAddress());
    }

    @Override
    String rrToString() {
        return Address.toDottedQuad(ARecord.toArray(this.addr));
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByAddress(ARecord.toArray(this.addr));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU32((long)this.addr & 0xFFFFFFFFL);
    }
}

