/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.callback;

import java.io.Serializable;
import org.apache.harmony.javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private int defaultChoice;
    private String prompt;
    private boolean multipleSelectionsAllowed;
    private String[] choices;
    private int[] selections;

    private void setChoices(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("auth.1C");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            throw new IllegalArgumentException("auth.1C");
        }
        this.choices = stringArray;
    }

    private void setPrompt(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        this.prompt = string;
    }

    private void setDefaultChoice(int n) {
        if (0 > n || n >= this.choices.length) {
            throw new IllegalArgumentException("auth.1D");
        }
        this.defaultChoice = n;
    }

    public ChoiceCallback(String string, String[] stringArray, int n, boolean bl) {
        this.setPrompt(string);
        this.setChoices(stringArray);
        this.setDefaultChoice(n);
        this.multipleSelectionsAllowed = bl;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }

    public void setSelectedIndex(int n) {
        this.selections = new int[1];
        this.selections[0] = n;
    }

    public void setSelectedIndexes(int[] nArray) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = nArray;
    }
}

