/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Set;

public final class PrivateCredentialPermission
extends Permission {
    private static final long serialVersionUID = 5284372143517237068L;
    private static final String READ = "read";
    private String credentialClass;
    private transient int offset;
    private transient CredOwner[] set;

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        if (!READ.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("auth.11");
        }
        this.initTargetName(string);
    }

    PrivateCredentialPermission(String string, Set<Principal> set) {
        super(string);
        this.credentialClass = string;
        this.set = new CredOwner[set.size()];
        for (Principal principal : set) {
            CredOwner credOwner = new CredOwner(principal.getClass().getName(), principal.getName());
            boolean bl = false;
            for (int i = 0; i < this.offset; ++i) {
                if (!this.set[i].equals(credOwner)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.set[this.offset++] = credOwner;
        }
    }

    private void initTargetName(String string) {
        if (string == null) {
            throw new NullPointerException("auth.0E");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("auth.0F");
        }
        int n = string.indexOf(32);
        if (n == -1) {
            throw new IllegalArgumentException("auth.10");
        }
        this.credentialClass = string.substring(0, n);
        ++n;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n < n3) {
            int n5 = string.indexOf(32, n);
            n4 = string.indexOf(34, n5 + 2);
            if (n5 == -1 || n4 == -1 || string.charAt(n5 + 1) != '\"') {
                throw new IllegalArgumentException("auth.10");
            }
            n = n4 + 2;
            ++n2;
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("auth.10");
        }
        n = string.indexOf(32);
        ++n;
        this.set = new CredOwner[n2];
        for (int i = 0; i < n2; ++i) {
            int n6 = string.indexOf(32, n);
            int n7 = string.indexOf(34, n6 + 2);
            String string2 = string.substring(n, n6);
            String string3 = string.substring(n6 + 2, n7);
            CredOwner credOwner = new CredOwner(string2, string3);
            boolean bl = false;
            for (int j = 0; j < this.offset; ++j) {
                if (!this.set[j].equals(credOwner)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.set[this.offset++] = credOwner;
            }
            n = n7 + 2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTargetName(this.getName());
    }

    public String[][] getPrincipals() {
        String[][] stringArray = new String[this.offset][2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i][0] = this.set[i].principalClass;
            stringArray[i][1] = this.set[i].principalName;
        }
        return stringArray;
    }

    @Override
    public String getActions() {
        return READ;
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.offset; ++i) {
            n += this.set[i].hashCode();
        }
        return this.getCredentialClass().hashCode() + n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        return this.credentialClass.equals(privateCredentialPermission.credentialClass) && this.offset == privateCredentialPermission.offset && this.sameMembers(this.set, privateCredentialPermission.set, this.offset);
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || this.getClass() != permission.getClass()) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!"*".equals(this.credentialClass) && !this.credentialClass.equals(privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        if (privateCredentialPermission.offset == 0) {
            return true;
        }
        CredOwner[] credOwnerArray = this.set;
        CredOwner[] credOwnerArray2 = privateCredentialPermission.set;
        int n = this.offset;
        int n2 = privateCredentialPermission.offset;
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n2 && !credOwnerArray[i].implies(credOwnerArray2[n3]); ++n3) {
            }
            if (n3 != credOwnerArray2.length) continue;
            return false;
        }
        return true;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private boolean sameMembers(Object[] objectArray, Object[] objectArray2, int n) {
        if (objectArray == null && objectArray2 == null) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (!objectArray[i].equals(objectArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static final class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        String principalClass;
        String principalName;
        private transient boolean isClassWildcard;
        private transient boolean isPNameWildcard;

        CredOwner(String string, String string2) {
            if ("*".equals(string)) {
                this.isClassWildcard = true;
            }
            if ("*".equals(string2)) {
                this.isPNameWildcard = true;
            }
            if (this.isClassWildcard && !this.isPNameWildcard) {
                throw new IllegalArgumentException("auth.12");
            }
            this.principalClass = string;
            this.principalName = string2;
        }

        boolean implies(Object object) {
            if (object == this) {
                return true;
            }
            CredOwner credOwner = (CredOwner)object;
            return !(!this.isClassWildcard && !this.principalClass.equals(credOwner.principalClass) || !this.isPNameWildcard && !this.principalName.equals(credOwner.principalName));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CredOwner) {
                CredOwner credOwner = (CredOwner)object;
                return this.principalClass.equals(credOwner.principalClass) && this.principalName.equals(credOwner.principalName);
            }
            return false;
        }

        public int hashCode() {
            return this.principalClass.hashCode() + this.principalName.hashCode();
        }
    }
}

