/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DigestChallenge;
import com.novell.sasl.client.ResponseAuth;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.RealmCallback;
import org.apache.harmony.javax.security.sasl.RealmChoiceCallback;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;

public class DigestMD5SaslClient
implements SaslClient {
    private String m_authorizationId = "";
    private String m_protocol = "";
    private String m_serverName = "";
    private Map m_props;
    private CallbackHandler m_cbh;
    private int m_state;
    private String m_qopValue = "";
    private char[] m_HA1 = null;
    private String m_digestURI;
    private DigestChallenge m_dc;
    private String m_clientNonce = "";
    private String m_realm = "";
    private String m_name = "";
    private static final int STATE_INITIAL = 0;
    private static final int STATE_DIGEST_RESPONSE_SENT = 1;
    private static final int STATE_VALID_SERVER_RESPONSE = 2;
    private static final int STATE_INVALID_SERVER_RESPONSE = 3;
    private static final int STATE_DISPOSED = 4;
    private static final int NONCE_BYTE_COUNT = 32;
    private static final int NONCE_HEX_COUNT = 64;
    private static final String DIGEST_METHOD = "AUTHENTICATE";

    public static SaslClient getClient(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) {
        String string4 = (String)map.get("javax.security.sasl.qop");
        String string5 = (String)map.get("javax.security.sasl.strength");
        String string6 = (String)map.get("javax.security.sasl.server.authentication");
        if (string4 != null && !"auth".equals(string4)) {
            return null;
        }
        if (string6 != null && !"false".equals(string6)) {
            return null;
        }
        if (callbackHandler == null) {
            return null;
        }
        return new DigestMD5SaslClient(string, string2, string3, map, callbackHandler);
    }

    private DigestMD5SaslClient(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) {
        this.m_authorizationId = string;
        this.m_protocol = string2;
        this.m_serverName = string3;
        this.m_props = map;
        this.m_cbh = callbackHandler;
        this.m_state = 0;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.m_state == 2 || this.m_state == 3 || this.m_state == 4;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (this.m_state != 2) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("javax.security.sasl.qop".equals(string)) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        if (this.m_state != 4) {
            this.m_state = 4;
        }
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        byte[] byArray2 = null;
        switch (this.m_state) {
            case 0: {
                if (byArray.length == 0) {
                    throw new SaslException("response = byte[0]");
                }
                try {
                    byArray2 = this.createDigestResponse(byArray).getBytes("UTF-8");
                    this.m_state = 1;
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SaslException("UTF-8 encoding not suppported by platform", unsupportedEncodingException);
                }
            }
            case 1: {
                if (this.checkServerResponseAuth(byArray)) {
                    this.m_state = 2;
                    break;
                }
                this.m_state = 3;
                throw new SaslException("Could not validate response-auth value from server");
            }
            case 2: 
            case 3: {
                throw new SaslException("Authentication sequence is complete");
            }
            case 4: {
                throw new SaslException("Client has been disposed");
            }
            default: {
                throw new SaslException("Unknown client state.");
            }
        }
        return byArray2;
    }

    char[] convertToHex(byte[] byArray) {
        int n = 15;
        char[] cArray = new char[32];
        for (int i = 0; i < 16; ++i) {
            cArray[i * 2] = DigestMD5SaslClient.getHexChar((byte)((byArray[i] & 0xF0) >> 4));
            cArray[i * 2 + 1] = DigestMD5SaslClient.getHexChar((byte)(byArray[i] & 0xF));
        }
        return cArray;
    }

    char[] DigestCalcHA1(String string, String string2, String string3, String string4, String string5, String string6) throws SaslException {
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string2.getBytes("UTF-8"));
            messageDigest.update(":".getBytes("UTF-8"));
            messageDigest.update(string3.getBytes("UTF-8"));
            messageDigest.update(":".getBytes("UTF-8"));
            messageDigest.update(string4.getBytes("UTF-8"));
            byArray = messageDigest.digest();
            if ("md5-sess".equals(string)) {
                messageDigest.update(byArray);
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(string5.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(string6.getBytes("UTF-8"));
                byArray = messageDigest.digest();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("No provider found for MD5 hash", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("UTF-8 encoding not supported by platform.", unsupportedEncodingException);
        }
        return this.convertToHex(byArray);
    }

    char[] DigestCalcResponse(char[] cArray, String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws SaslException {
        byte[] byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (bl) {
                messageDigest.update(string5.getBytes("UTF-8"));
            }
            messageDigest.update(":".getBytes("UTF-8"));
            messageDigest.update(string6.getBytes("UTF-8"));
            if ("auth-int".equals(string4)) {
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update("00000000000000000000000000000000".getBytes("UTF-8"));
            }
            byte[] byArray2 = messageDigest.digest();
            char[] cArray2 = this.convertToHex(byArray2);
            messageDigest.update(new String(cArray).getBytes("UTF-8"));
            messageDigest.update(":".getBytes("UTF-8"));
            messageDigest.update(string.getBytes("UTF-8"));
            messageDigest.update(":".getBytes("UTF-8"));
            if (string4.length() > 0) {
                messageDigest.update(string2.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(string3.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(string4.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
            }
            messageDigest.update(new String(cArray2).getBytes("UTF-8"));
            byArray = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("No provider found for MD5 hash", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("UTF-8 encoding not supported by platform.", unsupportedEncodingException);
        }
        return this.convertToHex(byArray);
    }

    private String createDigestResponse(byte[] byArray) throws SaslException {
        int[] nArray;
        StringBuffer stringBuffer = new StringBuffer(512);
        this.m_dc = new DigestChallenge(byArray);
        this.m_digestURI = this.m_protocol + "/" + this.m_serverName;
        if ((this.m_dc.getQop() & 1) != 1) {
            throw new SaslException("Client only supports qop of 'auth'");
        }
        this.m_qopValue = "auth";
        Callback[] callbackArray = new Callback[3];
        ArrayList arrayList = this.m_dc.getRealms();
        int n = arrayList.size();
        callbackArray[0] = n == 0 ? new RealmCallback("Realm") : (n == 1 ? new RealmCallback("Realm", (String)arrayList.get(0)) : new RealmChoiceCallback("Realm", arrayList.toArray(new String[n]), 0, false));
        callbackArray[1] = new PasswordCallback("Password", false);
        callbackArray[2] = this.m_authorizationId == null || this.m_authorizationId.length() == 0 ? new NameCallback("Name") : new NameCallback("Name", this.m_authorizationId);
        try {
            this.m_cbh.handle(callbackArray);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Handler does not support necessary callbacks", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new SaslException("IO exception in CallbackHandler.", iOException);
        }
        this.m_realm = n > 1 ? ((nArray = ((RealmChoiceCallback)callbackArray[0]).getSelectedIndexes()).length > 0 ? ((RealmChoiceCallback)callbackArray[0]).getChoices()[nArray[0]] : ((RealmChoiceCallback)callbackArray[0]).getChoices()[0]) : ((RealmCallback)callbackArray[0]).getText();
        this.m_clientNonce = this.getClientNonce();
        this.m_name = ((NameCallback)callbackArray[2]).getName();
        if (this.m_name == null) {
            this.m_name = ((NameCallback)callbackArray[2]).getDefaultName();
        }
        if (this.m_name == null) {
            throw new SaslException("No user name was specified.");
        }
        this.m_HA1 = this.DigestCalcHA1(this.m_dc.getAlgorithm(), this.m_name, this.m_realm, new String(((PasswordCallback)callbackArray[1]).getPassword()), this.m_dc.getNonce(), this.m_clientNonce);
        char[] cArray = this.DigestCalcResponse(this.m_HA1, this.m_dc.getNonce(), "00000001", this.m_clientNonce, this.m_qopValue, DIGEST_METHOD, this.m_digestURI, true);
        stringBuffer.append("username=\"");
        stringBuffer.append(this.m_authorizationId);
        if (0 != this.m_realm.length()) {
            stringBuffer.append("\",realm=\"");
            stringBuffer.append(this.m_realm);
        }
        stringBuffer.append("\",cnonce=\"");
        stringBuffer.append(this.m_clientNonce);
        stringBuffer.append("\",nc=");
        stringBuffer.append("00000001");
        stringBuffer.append(",qop=");
        stringBuffer.append(this.m_qopValue);
        stringBuffer.append(",digest-uri=\"");
        stringBuffer.append(this.m_digestURI);
        stringBuffer.append("\",response=");
        stringBuffer.append(cArray);
        stringBuffer.append(",charset=utf-8,nonce=\"");
        stringBuffer.append(this.m_dc.getNonce());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    boolean checkServerResponseAuth(byte[] byArray) throws SaslException {
        ResponseAuth responseAuth = null;
        responseAuth = new ResponseAuth(byArray);
        char[] cArray = this.DigestCalcResponse(this.m_HA1, this.m_dc.getNonce(), "00000001", this.m_clientNonce, this.m_qopValue, DIGEST_METHOD, this.m_digestURI, false);
        String string = new String(cArray);
        return string.equals(responseAuth.getResponseValue());
    }

    private static char getHexChar(byte by) {
        switch (by) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: {
                return 'f';
            }
        }
        return 'Z';
    }

    String getClientNonce() throws SaslException {
        byte[] byArray = new byte[32];
        char[] cArray = new char[64];
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.nextBytes(byArray);
            for (int i = 0; i < 32; ++i) {
                cArray[i * 2] = DigestMD5SaslClient.getHexChar((byte)(byArray[i] & 0xF));
                cArray[i * 2 + 1] = DigestMD5SaslClient.getHexChar((byte)((byArray[i] & 0xF0) >> 4));
            }
            return new String(cArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("No random number generator available", noSuchAlgorithmException);
        }
    }

    @Override
    public String getMechanismName() {
        return "DIGEST-MD5";
    }
}

