package com.beem.project.beem.jingle;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

public class RTPMediaManager extends JingleMediaManager {
	
	private static final SmackLogger LOGGER = SmackLogger.getLogger(RTPMediaManager.class);

	public static final String MEDIA_NAME = "RTP_BIDON";
	
	private List<PayloadType> payloads;

	public RTPMediaManager(JingleTransportManager transportManager) {
		super(transportManager);
		// TODO Auto-generated constructor stub
		setupPayloads();
		LOGGER.info("A TestMedia Manager is created(Receiver)");
	}

	@Override
	public JingleMediaSession createMediaSession(PayloadType payloadType,
			TransportCandidate remote, TransportCandidate local,
			JingleSession jingleSession) {
		// TODO Auto-generated method stub
		return new RTPMediaSession(payloadType, remote, local, null, jingleSession);
	}

	@Override
	public List<PayloadType> getPayloads() {
		// TODO Auto-generated method stub
		return payloads;
	}

	private void setupPayloads() {
		payloads = new ArrayList<PayloadType>();
		payloads.add(new PayloadType.Audio(51, "BIDON1"));
		payloads.add(new PayloadType.Audio(52, "BIDON2"));
		payloads.add(new PayloadType.Audio(53, "BIDON3"));
	}
	
	public String getName() {
		return MEDIA_NAME;
	}
}
