/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiatorManager;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.Bytestream;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Socks5TransferNegotiatorManager
implements FileTransferNegotiatorManager {
    private static final long BLACKLIST_LIFETIME = 0x6DDD00L;
    private final Object proxyLock = new Object();
    private static ProxyProcess proxyProcess;
    private final Object processLock = new Object();
    private final Cache<String, Integer> addressBlacklist = new Cache(100, 0x6DDD00L);
    private XMPPConnection connection;
    private List<String> proxies;
    private List<Bytestream.StreamHost> streamHosts;

    public Socks5TransferNegotiatorManager(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    @Override
    public StreamNegotiator createNegotiator() {
        return new Socks5TransferNegotiator(this, this.connection);
    }

    public void incrementConnectionFailures(String string) {
        Integer n = this.addressBlacklist.get(string);
        n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
        this.addressBlacklist.put(string, n);
    }

    public int getConnectionFailures(String string) {
        Integer n = this.addressBlacklist.get(string);
        return n != null ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyProcess addTransfer() throws IOException {
        Object object = this.processLock;
        synchronized (object) {
            if (proxyProcess == null) {
                proxyProcess = new ProxyProcess(new ServerSocket(7777));
                proxyProcess.start();
            }
        }
        proxyProcess.addTransfer();
        return proxyProcess;
    }

    public void removeTransfer() {
        if (proxyProcess == null) {
            return;
        }
        proxyProcess.removeTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Bytestream.StreamHost> getStreamHosts() {
        Object object = this.proxyLock;
        synchronized (object) {
            if (this.proxies == null) {
                this.initProxies();
            }
        }
        return Collections.unmodifiableCollection(this.streamHosts);
    }

    private String checkIsProxy(ServiceDiscoveryManager serviceDiscoveryManager, DiscoverItems.Item item) {
        DiscoverInfo discoverInfo;
        try {
            discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
        }
        catch (XMPPException xMPPException) {
            return null;
        }
        Iterator<DiscoverInfo.Identity> iterator = discoverInfo.getIdentities();
        while (iterator.hasNext()) {
            DiscoverInfo.Identity identity = iterator.next();
            if (!"proxy".equalsIgnoreCase(identity.getCategory()) || !"bytestreams".equalsIgnoreCase(identity.getType())) continue;
            return discoverInfo.getFrom();
        }
        return null;
    }

    private void initProxies() {
        this.proxies = new ArrayList<String>();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        try {
            DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(this.connection.getServiceName());
            Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
            while (iterator.hasNext()) {
                DiscoverItems.Item item = iterator.next();
                String string = this.checkIsProxy(serviceDiscoveryManager, item);
                if (string == null) continue;
                this.proxies.add(string);
            }
        }
        catch (XMPPException xMPPException) {
            return;
        }
        if (this.proxies.size() > 0) {
            this.initStreamHosts();
        }
    }

    private void initStreamHosts() {
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        for (String string : this.proxies) {
            IQ iQ = new IQ(){

                public String getChildElementXML() {
                    return "<query xmlns=\"http://jabber.org/protocol/bytestreams\"/>";
                }
            };
            iQ.setType(IQ.Type.GET);
            iQ.setTo(string);
            PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
            this.connection.sendPacket(iQ);
            Bytestream bytestream = (Bytestream)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            if (bytestream != null) {
                arrayList.addAll(bytestream.getStreamHosts());
            }
            packetCollector.cancel();
        }
        this.streamHosts = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.processLock;
        synchronized (object) {
            if (proxyProcess != null) {
                proxyProcess.stop();
                proxyProcess = null;
            }
        }
    }

    class ProxyProcess
    implements Runnable {
        private final ServerSocket listeningSocket;
        private final Map<String, Socket> connectionMap = new HashMap<String, Socket>();
        private boolean done = false;
        private Thread thread = new Thread((Runnable)this, "File Transfer Connection Listener");
        private int transfers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.listeningSocket.setSoTimeout(10000);
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                    try {
                        this.listeningSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                while (!this.done) {
                    Socket socket = null;
                    Object object = this;
                    synchronized (object) {
                        while (this.transfers <= 0 && !this.done) {
                            this.transfers = -1;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.done) {
                        break;
                    }
                    try {
                        object = this.listeningSocket;
                        synchronized (object) {
                            socket = this.listeningSocket.accept();
                        }
                        if (socket == null) continue;
                        object = this.establishSocks5UploadConnection(socket);
                        Map<String, Socket> map = this.connectionMap;
                        synchronized (map) {
                            this.connectionMap.put((String)object, socket);
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                        if (socket == null) continue;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                try {
                    this.listeningSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        private String establishSocks5UploadConnection(Socket socket) throws XMPPException, IOException {
            int n;
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            int n2 = ((InputStream)dataInputStream).read();
            if (n2 != 5) {
                throw new XMPPException("Only SOCKS5 supported");
            }
            n2 = ((InputStream)dataInputStream).read();
            int[] nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = ((InputStream)dataInputStream).read();
            }
            n = -1;
            for (int n3 : nArray) {
                int n4 = n = n3 == 0 ? 0 : -1;
                if (n == 0) break;
            }
            if (n != 0) {
                throw new XMPPException("Authentication method not supported");
            }
            byte[] byArray = new byte[]{5, 0};
            ((OutputStream)dataOutputStream).write(byArray);
            String string = Socks5TransferNegotiator.createIncomingSocks5Message(dataInputStream);
            byte[] byArray2 = Socks5TransferNegotiator.createOutgoingSocks5Message(0, string);
            if (!socket.isConnected()) {
                throw new XMPPException("Socket closed by remote user");
            }
            ((OutputStream)dataOutputStream).write(byArray2);
            return string;
        }

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.done = true;
            Object object = this;
            synchronized (object) {
                this.notify();
            }
            object = this.listeningSocket;
            synchronized (object) {
                this.listeningSocket.notify();
            }
        }

        public int getPort() {
            return this.listeningSocket.getLocalPort();
        }

        ProxyProcess(ServerSocket serverSocket) {
            this.listeningSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket(String string) {
            Map<String, Socket> map = this.connectionMap;
            synchronized (map) {
                return this.connectionMap.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTransfer() {
            ProxyProcess proxyProcess = this;
            synchronized (proxyProcess) {
                if (this.transfers == -1) {
                    this.transfers = 1;
                    this.notify();
                } else {
                    ++this.transfers;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTransfer() {
            ProxyProcess proxyProcess = this;
            synchronized (proxyProcess) {
                --this.transfers;
            }
        }
    }
}

