/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.umlgraph.doclet.ClassGraph;
import org.umlgraph.doclet.ClassInfo;
import org.umlgraph.doclet.ClassMatcher;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.Options;
import org.umlgraph.doclet.RelationPattern;

public class ContextMatcher
implements ClassMatcher {
    ClassGraphHack cg;
    Pattern pattern;
    List<ClassDoc> matched;
    Set<String> visited = new HashSet<String>();
    Options opt;
    RootDoc root;
    boolean keepParentHide;

    public ContextMatcher(RootDoc root, Pattern pattern, Options options, boolean keepParentHide) throws IOException {
        this.pattern = pattern;
        this.root = root;
        this.keepParentHide = keepParentHide;
        this.opt = (Options)options.clone();
        this.opt.setOption(new String[]{"-!hide"});
        this.opt.setOption(new String[]{"-!attributes"});
        this.opt.setOption(new String[]{"-!operations"});
        this.cg = new ClassGraphHack(root, this.opt);
        this.setContextCenter(pattern);
    }

    public void setContextCenter(Pattern pattern) {
        this.pattern = pattern;
        this.matched = new ArrayList<ClassDoc>();
        for (ClassDoc cd : this.root.classes()) {
            if (!pattern.matcher(cd.toString()).matches()) continue;
            this.matched.add(cd);
            this.addToGraph(cd);
        }
    }

    private void addToGraph(ClassDoc cd) {
        if (this.visited.contains(cd.toString())) {
            return;
        }
        this.visited.add(cd.toString());
        this.cg.printClass(cd, false);
        this.cg.printRelations(cd);
        if (this.opt.inferRelationships) {
            this.cg.printInferredRelations(cd);
        }
        if (this.opt.inferDependencies) {
            this.cg.printInferredDependencies(cd);
        }
    }

    @Override
    public boolean matches(ClassDoc cd) {
        if (this.keepParentHide && this.opt.matchesHideExpression(cd.toString())) {
            return false;
        }
        if (this.matched.contains(cd)) {
            return true;
        }
        this.addToGraph(cd);
        return this.matches(cd.toString());
    }

    @Override
    public boolean matches(String name) {
        if (this.pattern.matcher(name).matches()) {
            return true;
        }
        for (ClassDoc mcd : this.matched) {
            String mcName = mcd.toString();
            ClassInfo ciMatched = this.cg.getClassInfo(mcName);
            RelationPattern rp = ciMatched.getRelation(name);
            if (ciMatched == null || rp == null || !this.opt.contextRelationPattern.matchesOne(rp)) continue;
            return true;
        }
        return false;
    }

    private static class DevNullWriter
    extends Writer {
        private DevNullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class ClassGraphHack
    extends ClassGraph {
        public ClassGraphHack(RootDoc root, OptionProvider optionProvider) throws IOException {
            super(root, optionProvider, null);
            this.prologue();
        }

        @Override
        public void prologue() throws IOException {
            this.w = new PrintWriter(new DevNullWriter());
        }
    }
}

