/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.packet.Transcripts;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TranscriptsProvider
implements IQProvider {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    @Override
    public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue("", "userID");
        ArrayList<Transcripts.TranscriptSummary> arrayList = new ArrayList<Transcripts.TranscriptSummary>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (!xmlPullParser.getName().equals("transcript")) continue;
                arrayList.add(this.parseSummary(xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("transcripts")) continue;
            bl = true;
        }
        return new Transcripts(string, arrayList);
    }

    private Transcripts.TranscriptSummary parseSummary(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        String string = xmlPullParser.getAttributeValue("", "sessionID");
        Date date = null;
        Date date2 = null;
        List<Transcripts.AgentDetail> list = new ArrayList<Transcripts.AgentDetail>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("joinTime")) {
                    try {
                        date = UTC_FORMAT.parse(xmlPullParser.nextText());
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (xmlPullParser.getName().equals("leftTime")) {
                    try {
                        date2 = UTC_FORMAT.parse(xmlPullParser.nextText());
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (!xmlPullParser.getName().equals("agents")) continue;
                list = this.parseAgents(xmlPullParser);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("transcript")) continue;
            bl = true;
        }
        return new Transcripts.TranscriptSummary(string, date, date2, list);
    }

    private List<Transcripts.AgentDetail> parseAgents(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        ArrayList<Transcripts.AgentDetail> arrayList = new ArrayList<Transcripts.AgentDetail>();
        String string = null;
        Date date = null;
        Date date2 = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("agentJID")) {
                    string = xmlPullParser.nextText();
                    continue;
                }
                if (xmlPullParser.getName().equals("joinTime")) {
                    try {
                        date = UTC_FORMAT.parse(xmlPullParser.nextText());
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (xmlPullParser.getName().equals("leftTime")) {
                    try {
                        date2 = UTC_FORMAT.parse(xmlPullParser.nextText());
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (!xmlPullParser.getName().equals("agent")) continue;
                string = null;
                date = null;
                date2 = null;
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("agents")) {
                bl = true;
                continue;
            }
            if (!xmlPullParser.getName().equals("agent")) continue;
            arrayList.add(new Transcripts.AgentDetail(string, date, date2));
        }
        return arrayList;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }
}

