/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jivesoftware.smack.util.collections.EmptyIterator;
import org.jivesoftware.smack.util.collections.EmptyMapIterator;
import org.jivesoftware.smack.util.collections.IterableMap;
import org.jivesoftware.smack.util.collections.KeyValue;
import org.jivesoftware.smack.util.collections.MapIterator;

public class AbstractHashedMap<K, V>
extends AbstractMap<K, V>
implements IterableMap<K, V> {
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final int DEFAULT_THRESHOLD = 12;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final Object NULL = new Object();
    protected transient float loadFactor;
    protected transient int size;
    protected transient HashEntry<K, V>[] data;
    protected transient int threshold;
    protected transient int modCount;
    protected transient EntrySet<K, V> entrySet;
    protected transient KeySet<K, V> keySet;
    protected transient Values<K, V> values;

    protected AbstractHashedMap() {
    }

    protected AbstractHashedMap(int n, float f, int n2) {
        this.loadFactor = f;
        this.data = new HashEntry[n];
        this.threshold = n2;
        this.init();
    }

    protected AbstractHashedMap(int n) {
        this(n, 0.75f);
    }

    protected AbstractHashedMap(int n, float f) {
        if (n < 1) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = f;
        this.threshold = this.calculateThreshold(n, f);
        n = this.calculateNewCapacity(n);
        this.data = new HashEntry[n];
        this.init();
    }

    protected AbstractHashedMap(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 16), 0.75f);
        this.putAll(map);
    }

    protected void init() {
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object == null ? NULL : object);
        HashEntry<K, V> hashEntry = this.data[this.hashIndex(n, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, ((HashEntry)hashEntry).key)) {
                return hashEntry.getValue();
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hash(object == null ? NULL : object);
        HashEntry<K, V> hashEntry = this.data[this.hashIndex(n, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.getKey())) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            for (HashEntry<K, V> hashEntry : this.data) {
                while (hashEntry != null) {
                    if (hashEntry.getValue() == null) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        } else {
            for (HashEntry<K, V> hashEntry : this.data) {
                while (hashEntry != null) {
                    if (this.isEqualValue(object, hashEntry.getValue())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        int n = this.hash(k == null ? NULL : k);
        int n2 = this.hashIndex(n, this.data.length);
        HashEntry<K, V> hashEntry = this.data[n2];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(k, hashEntry.getKey())) {
                V v2 = hashEntry.getValue();
                this.updateEntry(hashEntry, v);
                return v2;
            }
            hashEntry = hashEntry.next;
        }
        this.addMapping(n2, n, k, v);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        int n2 = (int)((float)(this.size + n) / this.loadFactor + 1.0f);
        this.ensureCapacity(this.calculateNewCapacity(n2));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hash(object == null ? NULL : object);
        int n2 = this.hashIndex(n, this.data.length);
        HashEntry<K, V> hashEntry = this.data[n2];
        HashEntry<K, V> hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.getKey())) {
                V v = hashEntry.getValue();
                this.removeMapping(hashEntry, n2, hashEntry2);
                return v;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        HashEntry<K, V>[] hashEntryArray = this.data;
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            hashEntryArray[i] = null;
        }
        this.size = 0;
    }

    protected int hash(Object object) {
        int n = object.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected boolean isEqualKey(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    protected boolean isEqualValue(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected int hashIndex(int n, int n2) {
        return n & n2 - 1;
    }

    protected HashEntry<K, V> getEntry(Object object) {
        int n = this.hash(object == null ? NULL : object);
        HashEntry<K, V> hashEntry = this.data[this.hashIndex(n, this.data.length)];
        while (hashEntry != null) {
            if (hashEntry.hashCode == n && this.isEqualKey(object, hashEntry.getKey())) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected void updateEntry(HashEntry<K, V> hashEntry, V v) {
        hashEntry.setValue(v);
    }

    protected void reuseEntry(HashEntry<K, V> hashEntry, int n, int n2, K k, V v) {
        hashEntry.next = this.data[n];
        hashEntry.hashCode = n2;
        ((HashEntry)hashEntry).key = k;
        ((HashEntry)hashEntry).value = v;
    }

    protected void addMapping(int n, int n2, K k, V v) {
        ++this.modCount;
        HashEntry<K, V> hashEntry = this.createEntry(this.data[n], n2, k, v);
        this.addEntry(hashEntry, n);
        ++this.size;
        this.checkCapacity();
    }

    protected HashEntry<K, V> createEntry(HashEntry<K, V> hashEntry, int n, K k, V v) {
        return new HashEntry<K, V>(hashEntry, n, k, v);
    }

    protected void addEntry(HashEntry<K, V> hashEntry, int n) {
        this.data[n] = hashEntry;
    }

    protected void removeMapping(HashEntry<K, V> hashEntry, int n, HashEntry<K, V> hashEntry2) {
        ++this.modCount;
        this.removeEntry(hashEntry, n, hashEntry2);
        --this.size;
        this.destroyEntry(hashEntry);
    }

    protected void removeEntry(HashEntry<K, V> hashEntry, int n, HashEntry<K, V> hashEntry2) {
        if (hashEntry2 == null) {
            this.data[n] = hashEntry.next;
        } else {
            hashEntry2.next = hashEntry.next;
        }
    }

    protected void destroyEntry(HashEntry<K, V> hashEntry) {
        hashEntry.next = null;
        ((HashEntry)hashEntry).key = null;
        ((HashEntry)hashEntry).value = null;
    }

    protected void checkCapacity() {
        int n;
        if (this.size >= this.threshold && (n = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(n);
        }
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(n, this.loadFactor);
            this.data = new HashEntry[n];
        } else {
            HashEntry<K, V>[] hashEntryArray = this.data;
            HashEntry[] hashEntryArray2 = new HashEntry[n];
            ++this.modCount;
            for (int i = n2 - 1; i >= 0; --i) {
                HashEntry hashEntry;
                HashEntry<K, V> hashEntry2 = hashEntryArray[i];
                if (hashEntry2 == null) continue;
                hashEntryArray[i] = null;
                do {
                    hashEntry = hashEntry2.next;
                    int n3 = this.hashIndex(hashEntry2.hashCode, n);
                    hashEntry2.next = hashEntryArray2[n3];
                    hashEntryArray2[n3] = hashEntry2;
                } while ((hashEntry2 = hashEntry) != null);
            }
            this.threshold = this.calculateThreshold(n, this.loadFactor);
            this.data = hashEntryArray2;
        }
    }

    protected int calculateNewCapacity(int n) {
        int n2;
        if (n > 0x40000000) {
            n2 = 0x40000000;
        } else {
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            if (n2 > 0x40000000) {
                n2 = 0x40000000;
            }
        }
        return n2;
    }

    protected int calculateThreshold(int n, float f) {
        return (int)((float)n * f);
    }

    protected HashEntry<K, V> entryNext(HashEntry<K, V> hashEntry) {
        return hashEntry.next;
    }

    protected int entryHashCode(HashEntry<K, V> hashEntry) {
        return hashEntry.hashCode;
    }

    protected K entryKey(HashEntry<K, V> hashEntry) {
        return (K)((HashEntry)hashEntry).key;
    }

    protected V entryValue(HashEntry<K, V> hashEntry) {
        return (V)((HashEntry)hashEntry).value;
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new HashMapIterator(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator<K> createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator<V> createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.writeInt(this.size);
        MapIterator<K, V> mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
    }

    protected void doReadObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.loadFactor = objectInputStream.readFloat();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this.init();
        this.data = new HashEntry[n];
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
        this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
    }

    @Override
    protected Object clone() {
        try {
            AbstractHashedMap abstractHashedMap = (AbstractHashedMap)super.clone();
            abstractHashedMap.data = new HashEntry[this.data.length];
            abstractHashedMap.entrySet = null;
            abstractHashedMap.keySet = null;
            abstractHashedMap.values = null;
            abstractHashedMap.modCount = 0;
            abstractHashedMap.size = 0;
            abstractHashedMap.init();
            abstractHashedMap.putAll(this);
            return abstractHashedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        MapIterator<K, V> mapIterator = this.mapIterator();
        try {
            while (mapIterator.hasNext()) {
                K k = mapIterator.next();
                V v = mapIterator.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Iterator<Map.Entry<K, V>> iterator = this.createEntrySetIterator();
        while (iterator.hasNext()) {
            n += ((Object)iterator.next()).hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32 * this.size());
        stringBuilder.append('{');
        MapIterator<K, V> mapIterator = this.mapIterator();
        boolean bl = mapIterator.hasNext();
        while (bl) {
            K k = mapIterator.next();
            V v = mapIterator.getValue();
            stringBuilder.append((Object)(k == this ? "(this Map)" : k)).append('=').append((Object)(v == this ? "(this Map)" : v));
            bl = mapIterator.hasNext();
            if (!bl) continue;
            stringBuilder.append(',').append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected static abstract class HashIterator<K, V> {
        protected final AbstractHashedMap parent;
        protected int hashIndex;
        protected HashEntry<K, V> last;
        protected HashEntry<K, V> next;
        protected int expectedModCount;

        protected HashIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
            HashEntry<K, V>[] hashEntryArray = abstractHashedMap.data;
            int n = hashEntryArray.length;
            HashEntry hashEntry = null;
            while (n > 0 && hashEntry == null) {
                hashEntry = hashEntryArray[--n];
            }
            this.next = hashEntry;
            this.hashIndex = n;
            this.expectedModCount = abstractHashedMap.modCount;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected HashEntry<K, V> nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashEntry<K, V> hashEntry = this.next;
            if (hashEntry == null) {
                throw new NoSuchElementException(AbstractHashedMap.NO_NEXT_ENTRY);
            }
            HashEntry<K, V>[] hashEntryArray = this.parent.data;
            int n = this.hashIndex;
            HashEntry hashEntry2 = hashEntry.next;
            while (hashEntry2 == null && n > 0) {
                hashEntry2 = hashEntryArray[--n];
            }
            this.next = hashEntry2;
            this.hashIndex = n;
            this.last = hashEntry;
            return hashEntry;
        }

        protected HashEntry<K, V> currentEntry() {
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(AbstractHashedMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class HashEntry<K, V>
    implements Map.Entry<K, V>,
    KeyValue<K, V> {
        protected HashEntry<K, V> next;
        protected int hashCode;
        private K key;
        private V value;

        protected HashEntry(HashEntry<K, V> hashEntry, int n, K k, V v) {
            this.next = hashEntry;
            this.hashCode = n;
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public void setKey(K k) {
            this.key = k;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected static class ValuesIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<V> {
        protected ValuesIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public V next() {
            return super.nextEntry().getValue();
        }
    }

    protected static class Values<K, V>
    extends AbstractCollection<V> {
        protected final AbstractHashedMap<K, V> parent;

        protected Values(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return this.parent.createValuesIterator();
        }
    }

    protected static class KeySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<K> {
        protected KeySetIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }
    }

    protected static class KeySet<K, V>
    extends AbstractSet<K> {
        protected final AbstractHashedMap<K, V> parent;

        protected KeySet(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.parent.containsKey(object);
            this.parent.remove(object);
            return bl;
        }

        @Override
        public Iterator<K> iterator() {
            return this.parent.createKeySetIterator();
        }
    }

    protected static class EntrySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        protected EntrySetIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public HashEntry<K, V> next() {
            return super.nextEntry();
        }
    }

    protected static class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        protected final AbstractHashedMap<K, V> parent;

        protected EntrySet(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Map.Entry<K, V> entry) {
            Map.Entry<K, V> entry2 = entry;
            HashEntry<K, V> hashEntry = this.parent.getEntry(entry2.getKey());
            return hashEntry != null && ((Object)hashEntry).equals(entry2);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            if (!this.contains(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            this.parent.remove(k);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.parent.createEntrySetIterator();
        }
    }

    protected static class HashMapIterator<K, V>
    extends HashIterator<K, V>
    implements MapIterator<K, V> {
        protected HashMapIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }

        @Override
        public K getKey() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETKEY_INVALID);
            }
            return hashEntry.getKey();
        }

        @Override
        public V getValue() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETVALUE_INVALID);
            }
            return hashEntry.getValue();
        }

        @Override
        public V setValue(V v) {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.SETVALUE_INVALID);
            }
            return hashEntry.setValue(v);
        }
    }
}

