/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

 */

package com.beem.project.beem.account;

import java.util.ArrayList;

import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

import android.accounts.Account;
import android.accounts.OperationCanceledException;
import android.app.Service;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.OperationApplicationException;
import android.content.SyncResult;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.util.Log;

import com.beem.project.beem.BeemConnection;

/**
 * Class to integrate beem in android's account
 * @author marseille
 */
public class SyncAdapterService extends Service {

    private static final String TAG = "SynAcapterService";
    private static SyncAdapter mSyncAdapter = null;
    private static ContentResolver mContentResolver = null;
    private static Context mContext;

    /**
     * Constructor.
     */
    public SyncAdapterService() {
	super();
    }

    @Override
    public void onCreate() {
	mContext = SyncAdapterService.this;
    }

    @Override
    public IBinder onBind(Intent intent) {
	IBinder ret = null;
	ret = getSyncAdapter().getSyncAdapterBinder();
	return ret;

    }

    private SyncAdapter getSyncAdapter() {
	if (mSyncAdapter == null)
	    mSyncAdapter = new SyncAdapter(this, true);
	return mSyncAdapter;
    }

    /**
     * Method to sync Beem roster with Android
     * @param context context
     * @param account account
     * @param extras extras
     * @param authority authority
     * @param provider provider
     * @param syncResult syncResult
     * @throws OperationCanceledException OperationCanceledException
     */
    public static void performSync(Context context, final Account account, Bundle extras, String authority,
	ContentProviderClient provider, SyncResult syncResult) throws OperationCanceledException {
	mContentResolver = context.getContentResolver();
	Log.i(TAG, "performSync: " + account.toString());

	BeemConnection beemco = new BeemConnection(mContext.getSharedPreferences(account.name, MODE_PRIVATE), null);
	beemco.setNoPresence();
	XMPPConnection con = new XMPPConnection(beemco.getConnectionConfiguration());
	Roster roster = null;
	try {
	    con.connect();
	    con.login(beemco.getLogin(), beemco.getPassword(), "BEEM_SYNC_ADAPTER");
	    roster = con.getRoster();
	} catch (XMPPException e) {
	    Log.e(TAG, "Error while connecting with syncAdapter", e);
	} catch (IllegalStateException e) {
	    Log.e(TAG, "Not connected to server", e);
	}
	if (roster != null) {
	    manageRoster(roster, account);
	}
	con.disconnect();
    }

    private static void executeOperation(ArrayList<ContentProviderOperation> ops) {
	try {
	    mContentResolver.applyBatch(ContactsContract.AUTHORITY, ops);
	} catch (RemoteException e) {
	    Log.d(TAG, "Error during sync of contact", e);
	} catch (OperationApplicationException e) {
	    Log.d(TAG, "Error during sync of contact", e);
	}
    }

    private static void manageRoster(final Roster r, final Account a) {
	ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
	for (RosterEntry entry : r.getEntries()) {
	    if (entry != null) {
		manageEntry(ops, a, entry);
	    }
	    if (ops.size() > 100)
		executeOperation(ops);
	}
	// TODO: dont know how to ttest
	//	for (RosterGroup group : r.getGroups()) {
	//	    if (group != null)
	//		manageGroup(ops, a, group);
	//	    if (ops.size() > 0)
	//		    executeOperation(ops);
	//	}
	if (ops.size() > 0)
	    executeOperation(ops);
    }

    private static void manageEntry(ArrayList<ContentProviderOperation> ops, Account account, RosterEntry entry) {
	long rawContactID = getRawContactID(account.name, entry.getUser());
	String displayName = entry.getName() != null ? entry.getName() : entry.getUser();
	Log.i(TAG, "Sync Contact : " + entry.getUser() + " RawContactID : " + rawContactID);
	if (rawContactID == -1) { // Not found in database, add new
	    ContentValues values = new ContentValues();
	    values.put(ContactsContract.RawContacts.ACCOUNT_TYPE, account.type);
	    values.put(ContactsContract.RawContacts.ACCOUNT_NAME, account.name);
	    values.put(ContactsContract.RawContacts.SOURCE_ID, entry.getUser());
	    Uri rawContactUri = mContentResolver.insert(ContactsContract.RawContacts.CONTENT_URI, values);
	    rawContactID = ContentUris.parseId(rawContactUri);
	    values.clear();
	    //Insert Name values
	    ContentProviderOperation.Builder builder = ContentProviderOperation
		.newInsert(ContactsContract.Data.CONTENT_URI);
	    builder.withValue(ContactsContract.Data.RAW_CONTACT_ID, rawContactID);
	    builder.withValue(ContactsContract.Data.MIMETYPE,
		ContactsContract.CommonDataKinds.StructuredName.CONTENT_ITEM_TYPE);
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.RAW_CONTACT_ID, rawContactID);
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.DISPLAY_NAME, displayName);
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.GIVEN_NAME, displayName);
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.FAMILY_NAME, displayName);
	    ops.add(builder.build());
	    builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
	    builder.withValue(ContactsContract.Data.RAW_CONTACT_ID, rawContactID);
	    builder.withValue(ContactsContract.Data.MIMETYPE, ContactsContract.CommonDataKinds.Im.CONTENT_ITEM_TYPE);
	    builder.withValue(ContactsContract.CommonDataKinds.Im.RAW_CONTACT_ID, rawContactID);
	    builder.withValue(ContactsContract.CommonDataKinds.Im.DATA1, displayName);
	    builder.withValue(ContactsContract.CommonDataKinds.Im.PROTOCOL,
		ContactsContract.CommonDataKinds.Im.PROTOCOL_JABBER);
	    ops.add(builder.build());
	} else { // Found, update
	    // Update Name values
	    ContentProviderOperation.Builder builder = ContentProviderOperation
		.newUpdate(ContactsContract.Data.CONTENT_URI);
	    builder.withSelection(
		ContactsContract.CommonDataKinds.StructuredName.RAW_CONTACT_ID + " =? AND "
		    + ContactsContract.Data.MIMETYPE + " = '" + ContactsContract.CommonDataKinds.Im.CONTENT_ITEM_TYPE
		    + "'", new String[] { String.valueOf(rawContactID)});
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.DISPLAY_NAME, displayName);
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.GIVEN_NAME, displayName);
	    builder.withValue(ContactsContract.CommonDataKinds.StructuredName.FAMILY_NAME, displayName);
	    ops.add(builder.build());
	}
    }
   

    private static long getRawContactID(String account, String jid) {
	long authorId = -1;
	final Cursor c = mContentResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[] {
	    ContactsContract.RawContacts._ID, ContactsContract.RawContacts.SOURCE_ID },
	    ContactsContract.RawContacts.ACCOUNT_NAME + "=? AND " + ContactsContract.RawContacts.SOURCE_ID + "=?",
	    new String[] { account, jid }, null);
	try {
	    if (c.moveToFirst())
		authorId = c.getInt(c.getColumnIndex(ContactsContract.RawContacts._ID));
	} finally {
	    if (c != null)
		c.close();
	}
	return authorId;
    }

}
