/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import de.measite.smack.Sasl;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.TextInputCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.RealmCallback;
import org.apache.harmony.javax.security.sasl.RealmChoiceCallback;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.Base64;

public abstract class SASLMechanism
implements CallbackHandler {
    private SASLAuthentication saslAuthentication;
    protected SaslClient sc;
    protected String authenticationId;
    protected String password;
    protected String hostname;

    public SASLMechanism(SASLAuthentication sASLAuthentication) {
        this.saslAuthentication = sASLAuthentication;
    }

    public void authenticate(String string, String string2, String string3) throws IOException, XMPPException {
        this.authenticationId = string;
        this.password = string3;
        this.hostname = string2;
        String[] stringArray = new String[]{this.getName()};
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(stringArray, string, "xmpp", string2, hashMap, this);
        this.authenticate();
    }

    public void authenticate(String string, String string2, CallbackHandler callbackHandler) throws IOException, XMPPException {
        String[] stringArray = new String[]{this.getName()};
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(stringArray, string, "xmpp", string2, hashMap, callbackHandler);
        this.authenticate();
    }

    protected void authenticate() throws IOException, XMPPException {
        String string = null;
        try {
            if (this.sc.hasInitialResponse()) {
                byte[] byArray = this.sc.evaluateChallenge(new byte[0]);
                string = Base64.encodeBytes(byArray, 8);
            }
        }
        catch (SaslException saslException) {
            throw new XMPPException("SASL authentication failed", saslException);
        }
        this.getSASLAuthentication().send(new AuthMechanism(this.getName(), string));
    }

    public void challengeReceived(String string) throws IOException {
        byte[] byArray = string != null ? this.sc.evaluateChallenge(Base64.decode(string)) : this.sc.evaluateChallenge(new byte[0]);
        Response response = byArray == null ? new Response() : new Response(Base64.encodeBytes(byArray, 8));
        this.getSASLAuthentication().send(response);
    }

    protected abstract String getName();

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Serializable serializable;
            if (callbackArray[i] instanceof NameCallback) {
                serializable = (NameCallback)callbackArray[i];
                ((NameCallback)serializable).setName(this.authenticationId);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                serializable = (PasswordCallback)callbackArray[i];
                ((PasswordCallback)serializable).setPassword(this.password.toCharArray());
                continue;
            }
            if (callbackArray[i] instanceof RealmCallback) {
                serializable = (RealmCallback)callbackArray[i];
                ((TextInputCallback)serializable).setText(this.hostname);
                continue;
            }
            if (callbackArray[i] instanceof RealmChoiceCallback) continue;
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
    }

    public class Response
    extends Packet {
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String string) {
            this.authenticationText = string == null || string.trim().length() == 0 ? null : string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null) {
                stringBuilder.append(this.authenticationText);
            } else {
                stringBuilder.append("=");
            }
            stringBuilder.append("</response>");
            return stringBuilder.toString();
        }
    }

    public class AuthMechanism
    extends Packet {
        private final String name;
        private final String authenticationText;

        public AuthMechanism(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("SASL mechanism name shouldn't be null.");
            }
            this.name = string;
            this.authenticationText = string2;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<auth mechanism=\"").append(this.name);
            stringBuilder.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null && this.authenticationText.trim().length() > 0) {
                stringBuilder.append(this.authenticationText);
            }
            stringBuilder.append("</auth>");
            return stringBuilder.toString();
        }
    }
}

