/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.beem.project.beem.account;

import android.app.Dialog;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceScreen;
import android.util.Log;
import android.view.View;

import com.beem.project.beem.R;

public class ManageAccountsSettings extends AccountPreferences implements View.OnClickListener {
    
    protected static final String TAG = "AccountSettings";
    
    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Log.e(TAG,"ONCREATE");
        setContentView(R.layout.account_settings);
        addPreferencesFromResource(R.xml.preferences);  
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public boolean onPreferenceTreeClick(PreferenceScreen preferences, Preference preference) {
	 Log.e(TAG,"OnTreeclick()");
        return true;
    }

    @Override
    protected Dialog onCreateDialog(int id) {
	Log.e(TAG,"OnCreateDialog()");
        return null;
    }

    @Override
    public void onClick(View v) {
	Log.e(TAG, "onClick");
    }

}
