
package com.beem.project.beem.smack;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;
import android.util.Log;

public class AvatarMetadataProvider implements PacketExtensionProvider {

    /**
     * Creates a new AvatarMetadataProvider.
     * ProviderManager requires that every PacketExtensionProvider has a public, no-argument constructor
     */
    public AvatarMetadataProvider() {
    }

    @Override
    public PacketExtension parseExtension(XmlPullParser parser)
	throws Exception {
	Log.e("PROVIDER", "begin parsing");
	// TODO add id
	AvatarMetadataExtension metadata = null;
	boolean done = false;
	StringBuilder buffer = new StringBuilder();
	while (!done) {
	    int eventType = parser.next();
	    if (eventType == XmlPullParser.START_TAG) {
		if (parser.getName().equals("item")){
		    String id = parser.getAttributeValue(null, "id");
		    metadata = new AvatarMetadataExtension(id);
		} else if (parser.getName().equals("info")) {
		    AvatarMetadataExtension.Info info = new AvatarMetadataExtension.Info();
		    info.bytes = Integer.parseInt(parser.getAttributeValue(null, "bytes"));
		    info.height = Integer.parseInt(parser.getAttributeValue(null, "height"));
		    info.width = Integer.parseInt(parser.getAttributeValue(null, "width"));
		    info.id = parser.getAttributeValue(null, "id");
		    info.type = parser.getAttributeValue(null, "type");
		    info.setUrl(parser.getAttributeValue(null, "url"));
		    Log.e("PROVIDER", "add info");
		    metadata.addInfo(info);
		}
	    } else if (eventType == XmlPullParser.END_TAG) {
		    if (parser.getName().equals(metadata.getElementName())) {
			done = true;
		    }
	    }
	}
	Log.e("PROVIDER", "end parsing");
	return metadata;
    }
}
