/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.ui;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.widget.RemoteViews;

import com.beem.project.beem.R;

/**
 * SingletonClass notification.
 * @author Vincent V. <marseille@beem-project.com>
 */
public class BeemNotification extends Notification {

    private static Context mContext;
    private NotificationManager mNotificationManager;

    private static BeemNotification instance = null;

    /**
     * Constructor.
     */
    protected BeemNotification(Context c) {
	super();

	mNotificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
	Intent notificationIntent = new Intent();
	contentIntent = PendingIntent.getActivity(mContext, (int) System.currentTimeMillis(), notificationIntent,
	    PendingIntent.FLAG_UPDATE_CURRENT);
	icon = R.drawable.beem_status_icon;
	flags = Notification.FLAG_NO_CLEAR | Notification.FLAG_ONGOING_EVENT;
	contentView = new RemoteViews(mContext.getPackageName(), R.layout.notification);
	contentView.setTextViewText(R.id.pseudo, "Beem");
    }

    public static void BindNotification(Context c) {
	if (instance == null) {
	    instance = new BeemNotification(c);
	}
	instance.contentView.setTextViewText(R.id.msgstatus, "TODO: X messages unread");
	instance.mNotificationManager.notify(R.string.app_name, instance);

    }
    
    public static void SyncNotification(Context c) {
	
    }

    public void deleteNotification(int id) {
	mNotificationManager.cancel(id);
    }

}
