/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.jingle.demo;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.ConnectionConfiguration.SecurityMode;
import org.jivesoftware.smack.util.StringUtils;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.beem.project.beem.R;
import com.beem.project.beem.jingle.JingleService;

// TODO: Auto-generated Javadoc
/**
 * Activity used to test Jingle call.
 * @author darisk
 */
public class JingleCallActivity extends Activity {

    private static final int SLP_DURATION = 3000;
    private static final int DEFAULT_XMPP_PORT = 5222;

    private XMPPConnection mConnection;
    private ConnectionConfiguration mConf;
    private JingleService mJingle;

    private Button mBtconnect;
    private Button mBtcall;
    private EditText mEdJID;
    private EditText mEdPassword;
    private EditText mEdReceiver;

    /**
     * Constructor.
     */
    public JingleCallActivity() {
    }

    /* (non-Javadoc)
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	java.security.Security.addProvider(new com.sun.security.sasl.Provider());
	super.onCreate(savedInstanceState);
	setContentView(R.layout.jingle_call_activity);
	mConf = new ConnectionConfiguration("10.0.2.2", DEFAULT_XMPP_PORT);
	// mConf = new ConnectionConfiguration("elyzion.net",
	// DEFAULT_XMPP_PORT);
	mConf.setSecurityMode(SecurityMode.required);
	mEdJID = (EditText) findViewById(R.id.jingledemocalljid);
	mEdPassword = (EditText) findViewById(R.id.jingledemocallpassword);
	mEdReceiver = (EditText) findViewById(R.id.jingledemocallreceiver);
	mBtconnect = (Button) findViewById(R.id.jingledemocallconnectbutton);
	mBtconnect.setOnClickListener(new OnClickListener() {

	    @Override
	    public void onClick(View arg0) {
		String jid = mEdJID.getText().toString();
		String login = StringUtils.parseName(jid);
		mConnection = new XMPPConnection(mConf);
		String password = mEdPassword.getText().toString();
		try {
		    mConnection.connect();
		    Thread.sleep(SLP_DURATION);
		    mConnection.login(login, password);
		    mJingle = new JingleService(mConnection);
		    mJingle.initWhenConntected(mConnection);
		    mBtcall.setEnabled(true);
		    Toast.makeText(JingleCallActivity.this, "Connected", Toast.LENGTH_SHORT);
		} catch (XMPPException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
		} catch (InterruptedException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
		}
	    }

	});
	mBtcall = (Button) findViewById(R.id.jingledemocallbutton);
	mBtcall.setOnClickListener(new OnClickListener() {
	    @Override
	    public void onClick(View arg0) {
		String jid = mEdReceiver.getText().toString();
		if (!"".equals(jid)) {
		    mJingle.call(jid);
		    Toast.makeText(JingleCallActivity.this, "Appel en cours", Toast.LENGTH_SHORT);
		} else
		    Toast.makeText(JingleCallActivity.this, "Remplir le champ (JID complet en  toto@tutu.com/truc)",
			Toast.LENGTH_SHORT);
	    }
	});

    }

}
