/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.security.DomainCombiner;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.Subject;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private static final AuthPermission _GET = new AuthPermission("getSubjectFromDomainCombiner");

    public SubjectDomainCombiner(Subject subject) {
        if (subject == null) {
            throw new NullPointerException();
        }
        this.subject = subject;
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(_GET);
        }
        return this.subject;
    }

    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n = 0;
        if (protectionDomainArray != null) {
            n += protectionDomainArray.length;
        }
        if (protectionDomainArray2 != null) {
            n += protectionDomainArray2.length;
        }
        if (n == 0) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n];
        int n2 = 0;
        if (protectionDomainArray != null) {
            Set<Principal> set = this.subject.getPrincipals();
            Principal[] principalArray = set.toArray(new Principal[set.size()]);
            for (n2 = 0; n2 < protectionDomainArray.length; ++n2) {
                ProtectionDomain protectionDomain;
                protectionDomainArray3[n2] = protectionDomain = new ProtectionDomain(protectionDomainArray[n2].getCodeSource(), protectionDomainArray[n2].getPermissions(), protectionDomainArray[n2].getClassLoader(), principalArray);
            }
        }
        if (protectionDomainArray2 != null) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n2, protectionDomainArray2.length);
        }
        return protectionDomainArray3;
    }
}

