/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.Base64;

public abstract class SASLMechanism
implements CallbackHandler {
    private SASLAuthentication saslAuthentication;
    protected String authenticationId;
    protected String password;
    protected String hostname;

    public SASLMechanism(SASLAuthentication saslAuthentication) {
        this.saslAuthentication = saslAuthentication;
    }

    public void authenticate(String username, String host, String password) throws IOException, XMPPException {
        this.authenticationId = username;
        this.password = password;
        this.hostname = host;
        String[] mechanisms = new String[]{this.getName()};
        HashMap props = new HashMap();
        this.authenticate();
    }

    public void authenticate(String username, String host, CallbackHandler cbh) throws IOException, XMPPException {
        String[] mechanisms = new String[]{this.getName()};
        HashMap props = new HashMap();
        this.authenticate();
    }

    protected void authenticate() throws IOException, XMPPException {
        StringBuilder stanza = new StringBuilder();
        stanza.append("<auth mechanism=\"").append(this.getName());
        stanza.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        stanza.append("</auth>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    public void challengeReceived(String challenge) throws IOException {
        StringBuilder stanza = new StringBuilder();
        byte[] response = null;
        String authenticationText = Base64.encodeBytes(response, 8);
        if (authenticationText.equals("")) {
            authenticationText = "=";
        }
        stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        stanza.append(authenticationText);
        stanza.append("</response>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    protected abstract String getName();

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        if (i < callbacks.length) {
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

