/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDiscoveryManager {
    private static String identityName = "Smack";
    private static String identityType = "pc";
    private static Map<Connection, ServiceDiscoveryManager> instances = new ConcurrentHashMap<Connection, ServiceDiscoveryManager>();
    private Connection connection;
    private final List<String> features = new ArrayList<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();

    public ServiceDiscoveryManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    public static ServiceDiscoveryManager getInstanceFor(Connection connection) {
        return instances.get(connection);
    }

    public static String getIdentityName() {
        return identityName;
    }

    public static void setIdentityName(String string) {
        identityName = string;
    }

    public static String getIdentityType() {
        return identityType;
    }

    public static void setIdentityType(String string) {
        identityType = string;
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                instances.remove(ServiceDiscoveryManager.this.connection);
            }

            public void connectionClosedOnError(Exception exception) {
            }

            public void reconnectionFailed(Exception exception) {
            }

            public void reconnectingIn(int n) {
            }

            public void reconnectionSuccessful() {
            }
        });
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(DiscoverItems.class);
        PacketListener packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                DiscoverItems discoverItems = (DiscoverItems)packet;
                if (discoverItems != null && discoverItems.getType() == IQ.Type.GET) {
                    DiscoverItems discoverItems2 = new DiscoverItems();
                    discoverItems2.setType(IQ.Type.RESULT);
                    discoverItems2.setTo(discoverItems.getFrom());
                    discoverItems2.setPacketID(discoverItems.getPacketID());
                    discoverItems2.setNode(discoverItems.getNode());
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                    if (nodeInformationProvider != null) {
                        List<DiscoverItems.Item> list = nodeInformationProvider.getNodeItems();
                        if (list != null) {
                            for (DiscoverItems.Item item : list) {
                                discoverItems2.addItem(item);
                            }
                        }
                    } else if (discoverItems.getNode() != null) {
                        discoverItems2.setType(IQ.Type.ERROR);
                        discoverItems2.setError(new XMPPError(XMPPError.Condition.item_not_found));
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket(discoverItems2);
                }
            }
        };
        this.connection.addPacketListener(packetListener, packetTypeFilter);
        packetTypeFilter = new PacketTypeFilter(DiscoverInfo.class);
        packetListener = new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processPacket(Packet packet) {
                DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                if (discoverInfo != null && discoverInfo.getType() == IQ.Type.GET) {
                    DiscoverInfo discoverInfo2 = new DiscoverInfo();
                    discoverInfo2.setType(IQ.Type.RESULT);
                    discoverInfo2.setTo(discoverInfo.getFrom());
                    discoverInfo2.setPacketID(discoverInfo.getPacketID());
                    discoverInfo2.setNode(discoverInfo.getNode());
                    if (discoverInfo.getNode() == null) {
                        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", ServiceDiscoveryManager.getIdentityName());
                        identity.setType(ServiceDiscoveryManager.getIdentityType());
                        discoverInfo2.addIdentity(identity);
                        List list = ServiceDiscoveryManager.this.features;
                        synchronized (list) {
                            Iterator<String> iterator = ServiceDiscoveryManager.this.getFeatures();
                            while (iterator.hasNext()) {
                                discoverInfo2.addFeature(iterator.next());
                            }
                            if (ServiceDiscoveryManager.this.extendedInfo != null) {
                                discoverInfo2.addExtension(ServiceDiscoveryManager.this.extendedInfo);
                            }
                        }
                    } else {
                        NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                        if (nodeInformationProvider != null) {
                            Object object;
                            Object object2;
                            List<String> list = nodeInformationProvider.getNodeFeatures();
                            if (list != null) {
                                object2 = list.iterator();
                                while (object2.hasNext()) {
                                    object = (String)object2.next();
                                    discoverInfo2.addFeature((String)object);
                                }
                            }
                            if ((object2 = nodeInformationProvider.getNodeIdentities()) != null) {
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    DiscoverInfo.Identity identity = (DiscoverInfo.Identity)object.next();
                                    discoverInfo2.addIdentity(identity);
                                }
                            }
                        } else {
                            discoverInfo2.setType(IQ.Type.ERROR);
                            discoverInfo2.setError(new XMPPError(XMPPError.Condition.item_not_found));
                        }
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket(discoverInfo2);
                }
            }
        };
        this.connection.addPacketListener(packetListener, packetTypeFilter);
    }

    private NodeInformationProvider getNodeInformationProvider(String string) {
        if (string == null) {
            return null;
        }
        return this.nodeInformationProviders.get(string);
    }

    public void setNodeInformationProvider(String string, NodeInformationProvider nodeInformationProvider) {
        this.nodeInformationProviders.put(string, nodeInformationProvider);
    }

    public void removeNodeInformationProvider(String string) {
        this.nodeInformationProviders.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getFeatures() {
        List<String> list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.features)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String string) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String string) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String string) {
        List<String> list = this.features;
        synchronized (list) {
            return this.features.contains(string);
        }
    }

    public void setExtendedInfo(DataForm dataForm) {
        this.extendedInfo = dataForm;
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
    }

    public DiscoverInfo discoverInfo(String string) throws XMPPException {
        return this.discoverInfo(string, null);
    }

    public DiscoverInfo discoverInfo(String string, String string2) throws XMPPException {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.GET);
        discoverInfo.setTo(string);
        discoverInfo.setNode(string2);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(discoverInfo.getPacketID()));
        this.connection.sendPacket(discoverInfo);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        return (DiscoverInfo)iQ;
    }

    public DiscoverItems discoverItems(String string) throws XMPPException {
        return this.discoverItems(string, null);
    }

    public DiscoverItems discoverItems(String string, String string2) throws XMPPException {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setType(IQ.Type.GET);
        discoverItems.setTo(string);
        discoverItems.setNode(string2);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(discoverItems.getPacketID()));
        this.connection.sendPacket(discoverItems);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        return (DiscoverItems)iQ;
    }

    public boolean canPublishItems(String string) throws XMPPException {
        DiscoverInfo discoverInfo = this.discoverInfo(string);
        return discoverInfo.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String string, DiscoverItems discoverItems) throws XMPPException {
        this.publishItems(string, null, discoverItems);
    }

    public void publishItems(String string, String string2, DiscoverItems discoverItems) throws XMPPException {
        discoverItems.setType(IQ.Type.SET);
        discoverItems.setTo(string);
        discoverItems.setNode(string2);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(discoverItems.getPacketID()));
        this.connection.sendPacket(discoverItems);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                new ServiceDiscoveryManager(connection);
            }
        });
    }
}

