package com.beem.project.beem.service;

import android.os.Parcel;
import android.os.Parcelable;

public class PrivacyListItem implements Parcelable {

    private int mType;
    private String mValue;

    public static final Parcelable.Creator<PrivacyListItem> CREATOR = new Parcelable.Creator<PrivacyListItem>() {
	public PrivacyListItem createFromParcel(Parcel in) {
	    return new PrivacyListItem(in);
	}

	public PrivacyListItem[] newArray(int size) {
	    return new PrivacyListItem[size];
	}
    };

    public PrivacyListItem() {
    }

    public PrivacyListItem(Parcel in) {
	readFromParcel(in);
    }

    public PrivacyListItem(int type, String value) {
	mType = type;
	mValue = value;
    }

    @Override
    public int describeContents() {
	return 0;
    }

    public void readFromParcel(Parcel in) {
	mType = in.readInt();
	mValue = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
	dest.writeInt(mType);
	dest.writeString(mValue);
    }

    public int getType() {
	return mType;
    }

    public String getValue() {
	return mValue;
    }

    public void setType(final int type) {
	mType = type;
    }

    public void setValue(final String value) {
	mValue = value;
    }
}
