/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

public class Shape {
    private String name;

    public Shape() {
        this.name = "class";
    }

    public Shape(String n) {
        this.name = n;
        if (this.graphvizAttribute() == null) {
            System.err.println("Ignoring invalid shape " + n);
            this.name = "class";
        }
    }

    public String graphvizAttribute() {
        if (this.name.equals("class")) {
            return "";
        }
        if (this.name.equals("note")) {
            return ", shape=note";
        }
        if (this.name.equals("node")) {
            return ", shape=box3d";
        }
        if (this.name.equals("component")) {
            return ", shape=component";
        }
        if (this.name.equals("package")) {
            return ", shape=tab";
        }
        if (this.name.equals("collaboration")) {
            return ", shape=ellipse, style=dashed";
        }
        if (this.name.equals("usecase")) {
            return ", shape=ellipse";
        }
        if (this.name.equals("activeclass")) {
            return "";
        }
        return null;
    }

    String landingPort() {
        if (this.name.equals("class") || this.name.equals("activeclass")) {
            return ":p";
        }
        return "";
    }

    String extraColumn(int nRows) {
        return this.name.equals("activeclass") ? "<td rowspan=\"" + nRows + "\"></td>" : "";
    }

    String cellBorder() {
        return this.name.equals("class") || this.name.equals("activeclass") ? "1" : "0";
    }
}

