/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class IQ
extends Packet {
    private Type type = Type.GET;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.GET : type;
    }

    public String toXML() {
        XMPPError xMPPError;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<iq ");
        if (this.getPacketID() != null) {
            stringBuilder.append("id=\"" + this.getPacketID() + "\" ");
        }
        if (this.getTo() != null) {
            stringBuilder.append("to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\" ");
        }
        if (this.getFrom() != null) {
            stringBuilder.append("from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\" ");
        }
        if (this.type == null) {
            stringBuilder.append("type=\"get\">");
        } else {
            stringBuilder.append("type=\"").append(this.getType()).append("\">");
        }
        String string = this.getChildElementXML();
        if (string != null) {
            stringBuilder.append(string);
        }
        if ((xMPPError = this.getError()) != null) {
            stringBuilder.append(xMPPError.toXML());
        }
        stringBuilder.append("</iq>");
        return stringBuilder.toString();
    }

    public abstract String getChildElementXML();

    public static class Type {
        public static final Type GET = new Type("get");
        public static final Type SET = new Type("set");
        public static final Type RESULT = new Type("result");
        public static final Type ERROR = new Type("error");
        private String value;

        public static Type fromString(String string) {
            if (string == null) {
                return null;
            }
            string = string.toLowerCase();
            if (GET.toString().equals(string)) {
                return GET;
            }
            if (SET.toString().equals(string)) {
                return SET;
            }
            if (ERROR.toString().equals(string)) {
                return ERROR;
            }
            if (RESULT.toString().equals(string)) {
                return RESULT;
            }
            return null;
        }

        private Type(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

