package com.beem.project.beem.smack.caps;

import org.jivesoftware.smack.packet.PacketExtension;

public class CapsExtension implements PacketExtension {

    private String mVer;
    private String mHash;
    private String mNode;
    private String mExt;


    public CapsExtension(String hash, String node, String ver) {
	mHash = hash;
	mNode = node;
	mVer = ver;
    }

    public String getVer(){
	return mVer;
    }

    public String getHash(){
	return mHash;
    }

    public String getNode(){
	return mNode;
    }

    public String getExt(){
	return mExt;
    }

    public void setHash(String hash) {
	mHash = hash;
    }

    public void setVer(String ver) {
	mVer = ver;
    }

    public void setNode(String node) {
	mNode = node;
    }

    public void setExt(String ext) {
	mExt = ext;
    }

    @Override
     public String getElementName() {
	return "c";
     }

    @Override
     public String getNamespace() {
	 return "http://jabber.org/protocol/caps";
     }
		
    @Override
     public String toXML(){
	 StringBuilder b = new StringBuilder("<");
	 b.append(getElementName());
	 b.append(" xmlns=\"").append(getNamespace()).append("\" ");
	 if (mHash != null){
	     b.append("hash=\"").append(mHash).append("\" ");
	 }
	 if (mNode != null)
	     b.append("node=\"").append(mNode).append("\" ");
	 if (mVer != null)
	     b.append("ver=\"").append(mVer).append("\" ");
	 if (mExt!= null)
	     b.append("ext=\"").append(mExt).append("\" ");
	 b.append("/>");
	 return b.toString();
     }
}
