package com.beem.project.beem.account;

import android.accounts.Account;
import android.accounts.OperationCanceledException;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SyncResult;
import android.os.Bundle;
import android.util.Log;

public class SyncAdapter extends AbstractThreadedSyncAdapter {

    private Context mContext;
    private static final String TAG = "SyncAdapter";

    public SyncAdapter(Context context, boolean autoInitialize) {
	super(context, autoInitialize);
	mContext = context;
    }

    @Override
    public void onPerformSync(Account account, Bundle extras, String authority, ContentProviderClient provider,
	SyncResult syncResult) {
	try {
	    SyncAdapterService.performSync(mContext, account, extras, authority, provider, syncResult);
	} catch (OperationCanceledException e) {
	    Log.w(TAG, "Error while performSync", e);
	}

    }

}
