package com.beem.project.beem.ui;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.widget.RemoteViews;

import com.beem.project.beem.R;

/**
 * SingletonClass notification.
 * @author Vincent V. <marseille@beem-project.com>
 */
public class BeemNotification extends Notification {

    private static Context mContext;
    private NotificationManager mNotificationManager;

    private static BeemNotification instance = null;

    /**
     * Constructor.
     */
    protected BeemNotification() {
	super();

	mNotificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
	Intent notificationIntent = new Intent();
	contentIntent = PendingIntent.getActivity(mContext, (int) System.currentTimeMillis(), notificationIntent,
	    PendingIntent.FLAG_UPDATE_CURRENT);
	icon = R.drawable.beem_status_icon;	
	flags = Notification.FLAG_NO_CLEAR | Notification.FLAG_ONGOING_EVENT;
	contentView = new RemoteViews(mContext.getPackageName(), R.layout.notification);
	contentView.setTextViewText(R.id.pseudo, "Beem");
    }

    public static BeemNotification BindNotification(Context c) {
	if (instance == null) {
	    mContext = c;
	    instance = new BeemNotification();
	}		
	instance.contentView.setTextViewText(R.id.msgstatus, "TODO: X messages unread");
	instance.mNotificationManager.notify(R.string.app_name, instance);
	
	return instance;
    }

    public void deleteNotification(int id) {
	mNotificationManager.cancel(id);
    }

}
