/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class OfflineMessageRequest
extends IQ {
    private List items = new ArrayList();
    private boolean purge = false;
    private boolean fetch = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getItems() {
        List list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.items)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean bl) {
        this.purge = bl;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean bl) {
        this.fetch = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<offline xmlns=\"http://jabber.org/protocol/offline\">");
        List list = this.items;
        synchronized (list) {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)this.items.get(i);
                stringBuilder.append(item.toXML());
            }
        }
        if (this.purge) {
            stringBuilder.append("<purge/>");
        }
        if (this.fetch) {
            stringBuilder.append("<fetch/>");
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</offline>");
        return stringBuilder.toString();
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    if (xmlPullParser.getName().equals("item")) {
                        offlineMessageRequest.addItem(this.parseItem(xmlPullParser));
                        continue;
                    }
                    if (xmlPullParser.getName().equals("purge")) {
                        offlineMessageRequest.setPurge(true);
                        continue;
                    }
                    if (!xmlPullParser.getName().equals("fetch")) continue;
                    offlineMessageRequest.setFetch(true);
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("offline")) continue;
                bl = true;
            }
            return offlineMessageRequest;
        }

        private Item parseItem(XmlPullParser xmlPullParser) throws Exception {
            boolean bl = false;
            Item item = new Item(xmlPullParser.getAttributeValue("", "node"));
            item.setAction(xmlPullParser.getAttributeValue("", "action"));
            item.setJid(xmlPullParser.getAttributeValue("", "jid"));
            while (!bl) {
                int n = xmlPullParser.next();
                if (n != 3 || !xmlPullParser.getName().equals("item")) continue;
                bl = true;
            }
            return item;
        }
    }

    public static class Item {
        private String action;
        private String jid;
        private String node;

        public Item(String string) {
            this.node = string;
        }

        public String getNode() {
            return this.node;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String string) {
            this.action = string;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String string) {
            this.jid = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item");
            if (this.getAction() != null) {
                stringBuilder.append(" action=\"").append(this.getAction()).append("\"");
            }
            if (this.getJid() != null) {
                stringBuilder.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getNode() != null) {
                stringBuilder.append(" node=\"").append(this.getNode()).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

