package com.beem.project.beem.service;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.VCard;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.RemoteException;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.jingle.JingleService;
import com.beem.project.beem.service.aidl.IChatManager;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppConnection;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.ui.ChangeStatus;
import com.beem.project.beem.utils.PresenceType;
import com.beem.project.beem.utils.Status;

/**
 * This class is a facade for the Beem Service.
 * @author darisk
 */
public class XmppFacade extends IXmppFacade.Stub {

    private XmppConnectionAdapter mConnexion;
    private BeemService mBeemService;
    private JingleService mJingle;

    /**
     * Constructor for XMPPFacade.
     * @param connection the connection use by the facade
     * @param service the service which holds the facade
     * @param jingle the jingle session
     */
    public XmppFacade(final XmppConnectionAdapter connection, final BeemService service, final JingleService jingle) {
	this.mConnexion = connection;
	this.mBeemService = service;
	this.mJingle = jingle;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void changeStatus(int status, String msg) {
	mConnexion.changeStatus(status, msg);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectAsync() throws RemoteException {
	mConnexion.connectAsync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectSync() throws RemoteException {
	mConnexion.connectSync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IXmppConnection createConnection() throws RemoteException {
	return mConnexion;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void disconnect() throws RemoteException {
	mConnexion.disconnect();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IChatManager getChatManager() throws RemoteException {
	return mConnexion.getChatManager();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IRoster getRoster() throws RemoteException {
	return mConnexion.getRoster();
    }

    @Override
    public void sendPresencePacket(PresenceAdapter presence) throws RemoteException {
	Presence presence2 = new Presence(PresenceType.getPresenceTypeFrom(presence.getType()));
	presence2.setTo(presence.getTo());
	mConnexion.getAdaptee().sendPacket(presence2);
    }

    @Override
    public void blockUser(String jid) throws RemoteException {
	mConnexion.getPrivacyList().addBlockedUser(jid);
    }

    @Override
    public void call(String jid) throws RemoteException {
	mJingle.call(jid);
    }

    @Override
    public byte[] getVcardAvatar(String jid) throws RemoteException {
	VCard vcard = new VCard();

	try {
	    vcard.load(mConnexion.getAdaptee(), jid);
	    return vcard.getAvatar();
	} catch (XMPPException e) {
	    e.printStackTrace();
	}
	return null;
    }
}
