/**
 * 
 */
package com.beem.project.beem.account;

import java.util.ArrayList;

import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;

import android.accounts.Account;
import android.accounts.OperationCanceledException;
import android.app.Service;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.IBinder;
import android.provider.ContactsContract;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.RawContacts;
import android.provider.ContactsContract.CommonDataKinds.Im;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.util.Log;

import com.beem.project.beem.BeemConnection;

/**
 * @author marseille
 */
public class SyncAdapterService extends Service {

    private static final String TAG = "SynAcapterService";
    private static SyncAdapter mSyncAdapter = null;
    private static ContentResolver mContentResolver = null;
    private static Context mContext;

    public SyncAdapterService() {
	super();
    }

    @Override
    public void onCreate() {
	mContext = SyncAdapterService.this;
    }

    @Override
    public IBinder onBind(Intent intent) {
	IBinder ret = null;
	ret = getSyncAdapter().getSyncAdapterBinder();
	return ret;

    }

    private SyncAdapter getSyncAdapter() {
	if (mSyncAdapter == null)
	    mSyncAdapter = new SyncAdapter(this, true);
	return mSyncAdapter;
    }

    public static void performSync(Context context, final Account account, Bundle extras, String authority,
	ContentProviderClient provider, SyncResult syncResult) throws OperationCanceledException {
	mContentResolver = context.getContentResolver();
	Log.i(TAG, "performSync: " + account.toString());

	BeemConnection beemco = new BeemConnection(mContext.getSharedPreferences(account.name, MODE_PRIVATE), null);
	beemco.setNoPresence();
	XMPPConnection con = new XMPPConnection(beemco.getConnectionConfiguration());
	try {
	    con.connect();
	    con.login(beemco.getLogin(), beemco.getPassword(), "BEEM_SYNC_ADAPTER");

	    Roster roster = con.getRoster();
	    if (roster != null) {
		for (RosterEntry entry : roster.getEntries()) {
		    if (entry != null) {
			addEntry(account, entry);
		    }
		}
	    }
	} catch (XMPPException e) {	
	    Log.e(TAG, "Error while connecting with syncAdapter", e);
	}

	con.disconnect();

    }

    private static void addEntry(Account account, RosterEntry entry) {
	ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();

	int rawContactInsertIndex = ops.size();

	ContentProviderOperation.Builder builder = ContentProviderOperation.newInsert(RawContacts.CONTENT_URI);
	builder.withValue(RawContacts.ACCOUNT_NAME, account.name);
	builder.withValue(RawContacts.ACCOUNT_TYPE, account.type);
	builder.withValue(RawContacts.SYNC1, entry.getUser());
	ops.add(builder.build());

	builder = ContentProviderOperation.newInsert(Data.CONTENT_URI);
	builder.withValueBackReference(Data.RAW_CONTACT_ID, rawContactInsertIndex);
	builder.withValue(Data.MIMETYPE, StructuredName.CONTENT_ITEM_TYPE);
	builder.withValue(StructuredName.DISPLAY_NAME, entry.getUser());
	ops.add(builder.build());

	builder = ContentProviderOperation.newInsert(Data.CONTENT_URI);
	builder.withValueBackReference(Data.RAW_CONTACT_ID, 0);
	builder.withValue(Data.MIMETYPE, Im.CONTENT_ITEM_TYPE);
	builder.withValue(Im.DATA, entry.getUser());
	builder.withValue(Im.PROTOCOL, Im.PROTOCOL_JABBER);
	ops.add(builder.build());

	try {
	    mContentResolver.applyBatch(ContactsContract.AUTHORITY, ops);
	    Log.i(TAG, "added contact " + entry.getUser());
	} catch (Exception e) {
	    Log.d(TAG, "Error during add of contact", e);
	}
    }

}
