/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/
 */

package com.beem.project.beem.account;

import android.accounts.Account;
import android.accounts.OperationCanceledException;
import android.app.Service;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;

import com.beem.project.beem.BeemIntent;

/**
 * Class to integrate beem in android's account.
 * @author marseille
 */
public class SyncAdapterService extends Service {

    private static final int NB_DB_OPERATION = 50;
    private static final String TAG = "SynAcapterService";
    private static SyncAdapter mSyncAdapter = null;
    private static ContentResolver mContentResolver = null;
    private static Context mContext;

    /**
     * Constructor.
     */
    public SyncAdapterService() {
	super();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onCreate() {
	mContext = SyncAdapterService.this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IBinder onBind(Intent intent) {
	IBinder ret = null;
	ret = getSyncAdapter().getSyncAdapterBinder();
	return ret;

    }

    /**
     * Get syncAdapter instance.
     * @return sync adapter
     */
    private SyncAdapter getSyncAdapter() {
	if (mSyncAdapter == null)
	    mSyncAdapter = new SyncAdapter(this, true);
	return mSyncAdapter;
    }

    /**
     * Method to sync Beem roster with Android account.
     * @param context context
     * @param account account
     * @param extras extras
     * @param authority authority
     * @param provider provider
     * @param syncResult syncResult
     * @throws OperationCanceledException OperationCanceledException
     */
    public static void performSync(Context context, final Account account, Bundle extras, String authority,
	ContentProviderClient provider, SyncResult syncResult) throws OperationCanceledException {
	Log.i(TAG, "performSync: " + account.toString());
	Intent intent = new Intent(BeemIntent.ACTION_SYNC);
	intent.putExtra(BeemIntent.EXTRA_ACCOUNT, account.name);
	//	IntentFilter filter = new IntentFilter(BeemIntent.ACTION_CONNECTED);
	//	filter.addAction(BeemIntent.ACTION_DISCONNECTED);
	//	registerReceiver(mReceiver, filter);
	context.startService(intent);

	//	mContentResolver = context.getContentResolver();

	//
	//	//TODO: Get BeemService connectino support
	//	//TODO: Get resource information
	//	BeemConnection beemco = new BeemConnection(mContext.getSharedPreferences(account.name, MODE_PRIVATE), null);
	//	//if (!BeemService.getIsLaunch())
	//	//beemco.setNoPresence();
	//	XMPPConnection con = new XMPPConnection(beemco.getConnectionConfiguration());
	//	Roster roster = null;
	//	try {
	//	    con.connect();
	//	    //SharedPreferences sp = context.getSharedPreferences(account.name, MODE_PRIVATE);	    
	//	    con.login(beemco.getLogin(), beemco.getPassword(), "beem sync adapter");
	//	    roster = con.getRoster();
	//	} catch (XMPPException e) {
	//	    Log.e(TAG, "Error while connecting with syncAdapter", e);
	//	} catch (IllegalStateException e) {
	//	    Log.e(TAG, "Not connected to server", e);
	//	}
	//	if (roster != null)
	//	    manageRoster(roster, account);
	//	con.disconnect();
    }

}
