/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;

public class NXTRecord
extends Record {
    private static final long serialVersionUID = -8851454400765507520L;
    private Name next;
    private BitSet bitmap;

    NXTRecord() {
    }

    Record getObject() {
        return new NXTRecord();
    }

    public NXTRecord(Name name, int n, long l, Name name2, BitSet bitSet) {
        super(name, 30, n, l);
        this.next = NXTRecord.checkName("next", name2);
        this.bitmap = bitSet;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.next = new Name(dNSInput);
        this.bitmap = new BitSet();
        int n = dNSInput.remaining();
        for (int i = 0; i < n; ++i) {
            int n2 = dNSInput.readU8();
            for (int j = 0; j < 8; ++j) {
                if ((n2 & 1 << 7 - j) == 0) continue;
                this.bitmap.set(i * 8 + j);
            }
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Tokenizer.Token token;
        this.next = tokenizer.getName(name);
        this.bitmap = new BitSet();
        while ((token = tokenizer.get()).isString()) {
            int n = Type.value(token.value, true);
            if (n <= 0 || n > 128) {
                throw tokenizer.exception("Invalid type: " + token.value);
            }
            this.bitmap.set(n);
        }
        tokenizer.unget();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.next);
        int n = this.bitmap.length();
        for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            if (!this.bitmap.get(n2)) continue;
            stringBuffer.append(" ");
            stringBuffer.append(Type.string(n2));
        }
        return stringBuffer.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.next.toWire(dNSOutput, null, bl);
        int n = this.bitmap.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 |= this.bitmap.get(i) ? 1 << 7 - i % 8 : 0;
            if (i % 8 != 7 && i != n - 1) continue;
            dNSOutput.writeU8(n2);
            n2 = 0;
        }
    }
}

