/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.util.Arrays;

public class DSASignature {
    static final int ASN1_SEQ = 48;
    static final int ASN1_INT = 2;

    private DSASignature() {
    }

    public static byte[] fromDNS(byte[] byArray) {
        int n = 0;
        int n2 = 20;
        if (byArray[1] < 0) {
            n2 = (byte)(n2 + 1);
        }
        int n3 = 20;
        if (byArray[21] < 0) {
            n3 = (byte)(n3 + 1);
        }
        byte by = (byte)(n2 + n3 + 4);
        byte[] byArray2 = new byte[by + 2];
        byArray2[n++] = 48;
        byArray2[n++] = by;
        byArray2[n++] = 2;
        byArray2[n++] = n2;
        if (n2 > 20) {
            byArray2[n++] = 0;
        }
        int n4 = 0;
        while (n4 < 20) {
            byArray2[n] = byArray[1 + n4];
            ++n4;
            ++n;
        }
        byArray2[n++] = 2;
        byArray2[n++] = n3;
        if (n3 > 20) {
            byArray2[n++] = 0;
        }
        n4 = 0;
        while (n4 < 20) {
            byArray2[n] = byArray[21 + n4];
            ++n4;
            ++n;
        }
        return byArray2;
    }

    public static byte[] toDNS(DSAParams dSAParams, byte[] byArray) throws SignatureException {
        if (byArray[0] != 48 || byArray[2] != 2) {
            throw new SignatureException("Expected SEQ, INT");
        }
        int n = byArray[3];
        int n2 = 4;
        if (byArray[n2] == 0) {
            --n;
            ++n2;
        }
        if (byArray[n2 + n] != 2) {
            throw new SignatureException("Expected INT");
        }
        int n3 = byArray[n2 + n + 1];
        int n4 = n2 + n + 2;
        if (byArray[n4] == 0) {
            --n3;
            ++n4;
        }
        if (n > 20 || n3 > 20) {
            throw new SignatureException("DSA R/S too long");
        }
        byte[] byArray2 = new byte[41];
        Arrays.fill(byArray2, (byte)0);
        byArray2[0] = (byte)((dSAParams.getP().bitLength() - 512) / 64);
        System.arraycopy(byArray, n2, byArray2, 1 + (20 - n), n);
        System.arraycopy(byArray, n4, byArray2, 21 + (20 - n3), n3);
        return byArray2;
    }
}

