/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.ApacheHTTPResponse;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.CMSessionParams;
import com.kenai.jbosh.HTTPResponse;
import com.kenai.jbosh.HTTPSender;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

final class ApacheHTTPSender
implements HTTPSender {
    private final Lock lock = new ReentrantLock();
    private BOSHClientConfig cfg;
    private HttpClient httpClient;

    ApacheHTTPSender() {
        HttpClient.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BOSHClientConfig bOSHClientConfig) {
        this.lock.lock();
        try {
            this.cfg = bOSHClientConfig;
            this.httpClient = this.initHttpClient(bOSHClientConfig);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.lock();
        try {
            if (this.httpClient != null) {
                this.httpClient.getConnectionManager().shutdown();
            }
        }
        finally {
            this.cfg = null;
            this.httpClient = null;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse send(CMSessionParams cMSessionParams, AbstractBody abstractBody) {
        BOSHClientConfig bOSHClientConfig;
        HttpClient httpClient;
        this.lock.lock();
        try {
            if (this.httpClient == null) {
                this.httpClient = this.initHttpClient(this.cfg);
            }
            httpClient = this.httpClient;
            bOSHClientConfig = this.cfg;
        }
        finally {
            this.lock.unlock();
        }
        return new ApacheHTTPResponse(httpClient, bOSHClientConfig, cMSessionParams, abstractBody);
    }

    private synchronized HttpClient initHttpClient(BOSHClientConfig bOSHClientConfig) {
        SchemeRegistry schemeRegistry;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)100);
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)false);
        if (bOSHClientConfig != null && bOSHClientConfig.getProxyHost() != null && bOSHClientConfig.getProxyPort() != 0) {
            schemeRegistry = new HttpHost(bOSHClientConfig.getProxyHost(), bOSHClientConfig.getProxyPort());
            basicHttpParams.setParameter("http.route.default-proxy", (Object)schemeRegistry);
        }
        schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sSLSocketFactory = SSLSocketFactory.getSocketFactory();
        sSLSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sSLSocketFactory, 443));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        return new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
    }
}

