/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

 */
package com.beem.project.beem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.Roster.SubscriptionMode;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.UnknownPacket;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.PrivateDataManager;
import org.jivesoftware.smackx.XmppStreamHandler;
import org.jivesoftware.smackx.packet.ChatStateExtension;
import org.jivesoftware.smackx.provider.DelayInfoProvider;
import org.jivesoftware.smackx.provider.DiscoverInfoProvider;
import org.jivesoftware.smackx.provider.DiscoverItemsProvider;
import org.jivesoftware.smackx.pubsub.provider.EventProvider;
import org.jivesoftware.smackx.pubsub.provider.ItemProvider;
import org.jivesoftware.smackx.pubsub.provider.ItemsProvider;
import org.jivesoftware.smackx.pubsub.provider.PubSubProvider;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Service;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;

import com.beem.project.beem.smack.avatar.AvatarMetadataProvider;
import com.beem.project.beem.smack.avatar.AvatarProvider;
import com.beem.project.beem.smack.caps.CapsProvider;
import com.beem.project.beem.ui.Notification.BeemNotification;
import com.beem.project.beem.utils.BeemBroadcastReceiver;

/**
 * This class is for the Beem service. It must contains every global informations needed to maintain the background
 * service. The connection to the xmpp server will be made asynchronously when the service will start.
 * @author darisk
 */
public class BeemService extends Service {

    /** The id to use for status notification. */
    public static final int NOTIFICATION_STATUS_ID = 100;

    private static final String TAG = "BeemService";

    //private Map<String, XmppConnectionAdapter> mConnection = new HashMap<String, XmppConnectionAdapter>();

    private BeemServiceHandler mHandler;
    private BeemBroadcastReceiver mReceiver = new BeemBroadcastReceiver();
    private final BeemServicePreferenceListener mPreferenceListener = new BeemServicePreferenceListener();

    /**
     * Constructor.
     */
    public BeemService() {
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
	if (intent != null) {
	    mHandler.handleIntent(intent);
	}
	return Service.START_STICKY;
    }

    /**
     * {@inheritDoc}
     * @return return always null. Instead of bind, use intent.
     */
    @Override
    public IBinder onBind(Intent intent) {
	return null;
    }

    @Override
    public boolean onUnbind(Intent intent) {
	Log.d(TAG, "ONUNBIND()");
	//	boolean isConnected = true;
	//	for (XmppConnectionAdapter connection : mConnection.values()) {
	//	    if (!connection.getAdaptee().isConnected())
	//		isConnected = false;
	//	}
	//	if (!isConnected) {
	//	    this.stopSelf();
	//	}
	return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onCreate() {
	super.onCreate();
	Log.d(TAG, "ONCREATE");
	HandlerThread thread = new HandlerThread("BeemServiceThread");
	thread.start();
	mHandler = new BeemServiceHandler(thread.getLooper(), this);
	registerReceiver(mReceiver, new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
	//TODO: ADD AUTO AWAY OPTION DEPEND ON SCREEN OFF OR ON
	//	registerReceiver(mReceiver, new IntentFilter(Intent.ACTION_SCREEN_OFF));
	//	registerReceiver(mReceiver, new IntentFilter(Intent.ACTION_SCREEN_ON));
	configure(ProviderManager.getInstance());
	BeemNotification.BindNotification(this);
	Roster.setDefaultSubscriptionMode(SubscriptionMode.manual);
    }

    protected void onResume() {
	//Initialize preference listener.
	AccountManager am = AccountManager.get(this);
	Account allAccount[] = am.getAccountsByType(BeemApplication.BEEM_PACKAGE);
	for (Account account : allAccount) {
	    Log.e(TAG, " " + account.name);
	    getSharedPreferences(account.name, BeemService.MODE_PRIVATE).registerOnSharedPreferenceChangeListener(
		mPreferenceListener);
	}
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onDestroy() {
	super.onDestroy();
	unregisterReceiver(mReceiver);

	//	if (mOnOffReceiverIsRegistered)
	//	    unregisterReceiver(mOnOffReceiver);
	//	for (XmppConnectionAdapter connection : mConnection.values()) {
	//	    if (connection.isAuthentificated() && BeemConnectivity.isConnected(this))
	//		connection.disconnect();
	//	}
    }

    /**
     * Initialize Jingle from an XmppConnectionAdapter.
     * @param adaptee XmppConnection used for jingle.
     */
    public void initJingle(XMPPConnection adaptee) {
    }

    /**
     * Get the preference of the service.
     * @return the preference
     */
    //    public SharedPreferences getServicePreference(String accountName) {
    //	return mBeemConnection.get(accountName).getSettings();
    //    }

    /**
     * A sort of patch from this thread: http://www.igniterealtime.org/community/thread/31118. Avoid ClassCastException
     * by bypassing the classloading shit of Smack.
     * @param pm The ProviderManager.
     */
    private void configure(ProviderManager pm) {
	Log.d(TAG, "configure");
	// Service Discovery # Items
	pm.addIQProvider("query", "http://jabber.org/protocol/disco#items", new DiscoverItemsProvider());
	// Service Discovery # Info
	pm.addIQProvider("query", "http://jabber.org/protocol/disco#info", new DiscoverInfoProvider());

	// Privacy
	//pm.addIQProvider("query", "jabber:iq:privacy", new PrivacyProvider());
	// Delayed Delivery only the new version
	pm.addExtensionProvider("delay", "urn:xmpp:delay", new DelayInfoProvider());

	// Service Discovery # Items
	pm.addIQProvider("query", "http://jabber.org/protocol/disco#items", new DiscoverItemsProvider());
	// Service Discovery # Info
	pm.addIQProvider("query", "http://jabber.org/protocol/disco#info", new DiscoverInfoProvider());

	// Chat State
	ChatStateExtension.Provider chatState = new ChatStateExtension.Provider();
	pm.addExtensionProvider("active", "http://jabber.org/protocol/chatstates", chatState);
	pm.addExtensionProvider("composing", "http://jabber.org/protocol/chatstates", chatState);
	pm.addExtensionProvider("paused", "http://jabber.org/protocol/chatstates", chatState);
	pm.addExtensionProvider("inactive", "http://jabber.org/protocol/chatstates", chatState);
	pm.addExtensionProvider("gone", "http://jabber.org/protocol/chatstates", chatState);
	// capabilities
	pm.addExtensionProvider("c", "http://jabber.org/protocol/caps", new CapsProvider());
	//Pubsub
	pm.addIQProvider("pubsub", "http://jabber.org/protocol/pubsub", new PubSubProvider());
	pm.addExtensionProvider("items", "http://jabber.org/protocol/pubsub", new ItemsProvider());
	pm.addExtensionProvider("items", "http://jabber.org/protocol/pubsub", new ItemsProvider());
	pm.addExtensionProvider("item", "http://jabber.org/protocol/pubsub", new ItemProvider());

	pm.addExtensionProvider("items", "http://jabber.org/protocol/pubsub#event", new ItemsProvider());
	pm.addExtensionProvider("item", "http://jabber.org/protocol/pubsub#event", new ItemProvider());
	pm.addExtensionProvider("event", "http://jabber.org/protocol/pubsub#event", new EventProvider());
	//TODO rajouter les manquants pour du full pubsub

	//PEP avatar
	pm.addExtensionProvider("metadata", "urn:xmpp:avatar:metadata", new AvatarMetadataProvider());
	pm.addExtensionProvider("data", "urn:xmpp:avatar:data", new AvatarProvider());

	//         PEPProvider pep  = new PEPProvider();
	//         AvatarMetadataProvider avaMeta  = new AvatarMetadataProvider();
	//         pep.registerPEPParserExtension("urn:xmpp:avatar:metadata", avaMeta);
	//         pm.addExtensionProvider("event", "http://jabber.org/protocol/pubsub#event", pep);

	// Private Data Storage for Bookmarks	
	pm.addIQProvider("query", "jabber:iq:private", new PrivateDataManager.PrivateDataIQProvider());

	// ping
	pm.addIQProvider(BeemPacketListener.PingExtension.ELEMENT, BeemPacketListener.PingExtension.NAMESPACE, BeemPacketListener.PingExtension.class);

	
	// Time 
	//	try {
	//	    pm.addIQProvider("query", "jabber:iq:time", Class.forName("org.jivesoftware.smackx.packet.Time"));
	//	} catch (ClassNotFoundException e) {
	//	    Log.w("TestClient", "Can't load class for org.jivesoftware.smackx.packet.Time");
	//	}
	//	// Roster Exchange
	//	pm.addExtensionProvider("x", "jabber:x:roster", new RosterExchangeProvider());
	//	// Message Events
	//	pm.addExtensionProvider("x", "jabber:x:event", new MessageEventProvider());
	//	// XHTML
	//	pm.addExtensionProvider("html", "http://jabber.org/protocol/xhtml-im", new XHTMLExtensionProvider());
	//	//Group Chat Invitations 
	//	pm.addExtensionProvider("x", "jabber:x:conference", new GroupChatInvitation.Provider());
	//	// Data Forms 
	//	pm.addExtensionProvider("x", "jabber:x:data", new DataFormProvider()); // MUC User 
	//	pm.addExtensionProvider("x", "http://jabber.org/protocol/muc#user", new MUCUserProvider());
	//	// MUC Admin 
	//	pm.addIQProvider("query", "http://jabber.org/protocol/muc#admin", new MUCAdminProvider());
	//	// MUC Owner 
	//	pm.addIQProvider("query", "http://jabber.org/protocol/muc#owner", new MUCOwnerProvider());
	//	// Version 
	//	try {
	//	    pm.addIQProvider("query", "jabber:iq:version", Class.forName("org.jivesoftware.smackx.packet.Version"));
	//	} catch (ClassNotFoundException e) {
	//	    // Not sure what's happening here. 
	//	    Log.w("TestClient", "Can't load class for org.jivesoftware.smackx.packet.Version");
	//	}
	//	// VCard 
	//	pm.addIQProvider("vCard", "vcard-temp", new VCardProvider());
	//	// Offline Message Requests
	//	pm.addIQProvider("offline", "http://jabber.org/protocol/offline", new OfflineMessageRequest.Provider());
	//	// Offline Message Indicator 
	//	pm.addExtensionProvider("offline", "http://jabber.org/protocol/offline", new OfflineMessageInfo.Provider());
	//	// Last Activity 
	//	pm.addIQProvider("query", "jabber:iq:last", new LastActivity.Provider());
	//	// User Search 
	//	pm.addIQProvider("query", "jabber:iq:search", new UserSearch.Provider());
	//	// SharedGroupsInfo 
	//	pm.addIQProvider("sharedgroup", "http://www.jivesoftware.org/protocol/sharedgroup",
	//	    new SharedGroupsInfo.Provider());
	//	// JEP-33: Extended  Stanza Addressing 
	//	pm.addExtensionProvider("addresses", "http://jabber.org/protocol/address", new MultipleAddressesProvider());
	// FileTransfer 
	//	pm.addIQProvider("si", "http://jabber.org/protocol/si", new StreamInitiationProvider());
	//	pm.addIQProvider("query", "http://jabber.org/protocol/bytestreams", new BytestreamsProvider());
	//	pm.addIQProvider("open", "http://jabber.org/protocol/ibb", new IBBProviders.Open());
	//	pm.addIQProvider("close", "http://jabber.org/protocol/ibb", new IBBProviders.Close());
	//	pm.addExtensionProvider("data", "http://jabber.org/protocol/ibb", new IBBProviders.Data());
	//	pm.addIQProvider("command", COMMAND_NAMESPACE, new AdHocCommandDataProvider());
	//	pm.addExtensionProvider("malformed-action", COMMAND_NAMESPACE,
	//	    new AdHocCommandDataProvider.MalformedActionError());
	//	pm.addExtensionProvider("bad-locale", COMMAND_NAMESPACE, new AdHocCommandDataProvider.BadLocaleError());
	//	pm.addExtensionProvider("bad-payload", COMMAND_NAMESPACE, new AdHocCommandDataProvider.BadPayloadError());
	//	pm.addExtensionProvider("bad-sessionid", COMMAND_NAMESPACE, new AdHocCommandDataProvider.BadSessionIDError());
	//	pm.addExtensionProvider("session-expired", COMMAND_NAMESPACE,
	//	    new AdHocCommandDataProvider.SessionExpiredError());
	XmppStreamHandler.addExtensionProviders();
    }

    /**
     * Listen on preference changes.
     */
    public class BeemServicePreferenceListener implements SharedPreferences.OnSharedPreferenceChangeListener {

	/**
	 * ctor.
	 */
	public BeemServicePreferenceListener() {
	    Log.e(TAG, "CONSTRUCTOR");
	}

	@Override
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
	    Log.e(TAG, "OO" + key);
	    if ("settings_away_chk".equals(key)) {
		//		if (sharedPreferences.getBoolean("settings_away_chk", false)) {
		//		    mOnOffReceiverIsRegistered = true;
		//		    registerReceiver(mOnOffReceiver, new IntentFilter(Intent.ACTION_SCREEN_OFF));
		//		    registerReceiver(mOnOffReceiver, new IntentFilter(Intent.ACTION_SCREEN_ON));
		//		} else {
		//		    mOnOffReceiverIsRegistered = false;
		//		    unregisterReceiver(mOnOffReceiver);
		//		}
	    } else if (BeemApplication.STATUS_TEXT_KEY.equals(key)) {
		//		BeemNotification.BindNotification(BeemService.this);
	    } else if (BeemApplication.NOTIFICATION_ENABLE_KEY.equals(key)) {
		Log.e(TAG, "OO");
	    }
	}
    }

    public static class StreamHandlingPacket extends UnknownPacket {
	private String name;
	private String namespace;
	Map<String, String> attributes;

	public StreamHandlingPacket(String name, String namespace) {
	    this.name = name;
	    this.namespace = namespace;
	    attributes = Collections.emptyMap();
	}

	public void addAttribute(String name, String value) {
	    if (attributes == Collections.EMPTY_MAP)
		attributes = new HashMap<String, String>();
	    attributes.put(name, value);
	}

	public String getAttribute(String name) {
	    return attributes.get(name);
	}

	public String getNamespace() {
	    return namespace;
	}

	public String getElementName() {
	    return name;
	}

	public String toXML() {
	    StringBuilder buf = new StringBuilder();
	    buf.append("<").append(getElementName());

	    // TODO Xmlns??
	    if (getNamespace() != null) {
		buf.append(" xmlns=\"").append(getNamespace()).append("\"");
	    }
	    for (String key : attributes.keySet()) {
		buf.append(" ").append(key).append("=\"").append(StringUtils.escapeForXML(attributes.get(key)))
		    .append("\"");
	    }
	    buf.append("/>");
	    return buf.toString();
	}

    }

}
