/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import org.jlibrtp.jlibrtp.RtcpPkt;
import org.jlibrtp.jlibrtp.RtcpPktRR;
import org.jlibrtp.jlibrtp.StaticProcs;

public class RtcpPktSR
extends RtcpPkt {
    protected long ntpTs1 = -1L;
    protected long ntpTs2 = -1L;
    protected long rtpTs = -1L;
    protected long sendersPktCount = -1L;
    protected long sendersOctCount = -1L;
    protected RtcpPktRR rReports = null;

    protected RtcpPktSR(long ssrc, long pktCount, long octCount, RtcpPktRR rReports) {
        this.ssrc = ssrc;
        this.packetType = 200;
        this.sendersPktCount = pktCount;
        this.sendersOctCount = octCount;
        this.rReports = rReports;
    }

    protected RtcpPktSR(byte[] aRawPkt, int start, int length) {
        this.rawPkt = aRawPkt;
        if (!super.parseHeaders(start) || this.packetType != 200) {
            this.problem = -200;
        } else {
            this.ssrc = StaticProcs.bytesToUIntLong(aRawPkt, 4 + start);
            if (length > 11) {
                this.ntpTs1 = StaticProcs.bytesToUIntLong(aRawPkt, 8 + start);
            }
            if (length > 15) {
                this.ntpTs2 = StaticProcs.bytesToUIntLong(aRawPkt, 12 + start);
            }
            if (length > 19) {
                this.rtpTs = StaticProcs.bytesToUIntLong(aRawPkt, 16 + start);
            }
            if (length > 23) {
                this.sendersPktCount = StaticProcs.bytesToUIntLong(aRawPkt, 20 + start);
            }
            if (length > 27) {
                this.sendersOctCount = StaticProcs.bytesToUIntLong(aRawPkt, 24 + start);
            }
            if (this.itemCount > 0) {
                this.rReports = new RtcpPktRR(this.rawPkt, start, this.itemCount);
            }
        }
    }

    @Override
    protected void encode() {
        if (this.rReports != null) {
            this.itemCount = this.rReports.reportees.length;
            byte[] tmp = this.rReports.encodeRR();
            this.rawPkt = new byte[tmp.length + 28];
            System.arraycopy(tmp, 0, this.rawPkt, 28, tmp.length);
        } else {
            this.itemCount = 0;
            this.rawPkt = new byte[28];
        }
        super.writeHeaders();
        long timeNow = System.currentTimeMillis();
        this.ntpTs1 = 2208988800L + timeNow / 1000L;
        long ms = timeNow % 1000L;
        double tmp = (double)ms / 1000.0;
        this.ntpTs2 = (long)(tmp *= 4.294967295E9);
        this.rtpTs = System.currentTimeMillis();
        byte[] someBytes = StaticProcs.uIntLongToByteWord(this.ssrc);
        System.arraycopy(someBytes, 0, this.rawPkt, 4, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.ntpTs1);
        System.arraycopy(someBytes, 0, this.rawPkt, 8, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.ntpTs2);
        System.arraycopy(someBytes, 0, this.rawPkt, 12, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.rtpTs);
        System.arraycopy(someBytes, 0, this.rawPkt, 16, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.sendersPktCount);
        System.arraycopy(someBytes, 0, this.rawPkt, 20, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.sendersOctCount);
        System.arraycopy(someBytes, 0, this.rawPkt, 24, 4);
    }

    public void debugPrint() {
        System.out.println("RtcpPktSR.debugPrint() ");
        System.out.println("  SSRC:" + Long.toString(this.ssrc) + " ntpTs1:" + Long.toString(this.ntpTs1) + " ntpTS2:" + Long.toString(this.ntpTs2) + " rtpTS:" + Long.toString(this.rtpTs) + " senderPktCount:" + Long.toString(this.sendersPktCount) + " sendersOctetCount:" + Long.toString(this.sendersOctCount));
        if (this.rReports != null) {
            System.out.print("  Part of Sender Report: ");
            this.rReports.debugPrint();
            System.out.println("  End Sender Report");
        } else {
            System.out.println("No Receiver Reports associated with this Sender Report.");
        }
    }
}

