/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

 */
package com.beem.project.beem.ui;

import java.util.ArrayList;
import java.util.List;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.R;
import com.beem.project.beem.service.LoginAsyncTask;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * This class is the main Activity for the Beem project.
 * @author Da Risk <darisk@beem-project.com>
 */
public class Login extends Activity {

    private static final Intent SERVICE_INTENT = new Intent();
    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }
    private static final int LOGIN_REQUEST_CODE = 1;
    private TextView mTextView;
    private BeemApplication mBeemApplication;
    private String mAccountName;
    private final ServiceConnection mServConn = new LoginServiceConnection();
    private IXmppFacade mXmppFacade;
    private AsyncTask<IXmppFacade, Integer, Boolean> mTask;
    private Animation mAnimationLogo;

    List<String> mListAccount = new ArrayList<String>();
    private BeemAccountList mAdapterAccountList;
    private final BeemAccountListOnClick mOnAccountClick = new BeemAccountListOnClick();

    /**
     * Constructor.
     */
    public Login() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);

	setContentView(R.layout.login);
	mTextView = (TextView) findViewById(R.id.log_as_msg);
	ListView listView = (ListView) findViewById(R.id.accountlist);
	mAdapterAccountList = new BeemAccountList(getLayoutInflater());
	listView.setClickable(true);
	listView.setOnItemClickListener(mOnAccountClick);
	listView.setAdapter(mAdapterAccountList);
	mAnimationLogo = AnimationUtils.loadAnimation(Login.this, R.anim.rotate_and_scale);
	Intent i = new Intent(Login.SERVICE_INTENT);
	startService(i);
    }

    @Override
    protected void onStart() {
	super.onStart();
	mTextView.setText(R.string.login_start_msg);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
	super.onCreateOptionsMenu(menu);
	MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.login, menu);
	return true;
    }
    
    @Override
    protected void onDestroy() {     
        super.onDestroy();
        //unbindService(mServConn);
    }

    @Override
    public final boolean onOptionsItemSelected(MenuItem item) {
	boolean result;
	switch (item.getItemId()) {
	    case R.id.login_menu_settings:
		mTextView.setText("");
		startActivity(new Intent(Login.this, Settings.class));
		result = true;
		break;
	    case R.id.login_menu_about:
		createAboutDialog();
		result = true;
		break;
	    case R.id.login_menu_login:
		result = true;
		break;
	    default:
		result = false;
		break;
	}
	return result;
    }

    /**
     * Create an about "BEEM" dialog.
     */
    private void createAboutDialog() {
	AlertDialog.Builder builder = new AlertDialog.Builder(this);
	String versionname;
	try {
	    PackageManager pm = getPackageManager();
	    PackageInfo pi = pm.getPackageInfo("com.beem.project.beem", 0);
	    versionname = pi.versionName;
	} catch (PackageManager.NameNotFoundException e) {
	    versionname = "";
	}
	String title = getString(R.string.login_about_title, versionname);
	builder.setTitle(title).setMessage(R.string.login_about_msg).setCancelable(false);
	builder.setNeutralButton(R.string.login_about_button, new DialogInterface.OnClickListener() {

	    public void onClick(DialogInterface dialog, int whichButton) {
		dialog.cancel();
	    }
	});
	AlertDialog aboutDialog = builder.create();
	aboutDialog.show();
    }

    private class BeemAccountList extends BaseAdapter {

	private LayoutInflater mInflater;

	public BeemAccountList(LayoutInflater layoutInflater) {
	    mInflater = layoutInflater;
	    AccountManager am = AccountManager.get(Login.this);
	    Account allAccount[] = am.getAccountsByType("com.beem.project.com");
	    for (Account account : allAccount) {
		mListAccount.add(account.name);
	    }
	}

	@Override
	public int getCount() {
	    return mListAccount.size();
	}

	@Override
	public Object getItem(int position) {
	    return mListAccount.get(position);
	}

	@Override
	public long getItemId(int position) {
	    return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
	    View v = convertView;
	    if (convertView == null) {
		v = mInflater.inflate(R.layout.login_row_account, null);
	    }
	    ImageButton logo = (ImageButton) v.findViewById(R.id.loginanim_logo_anim);
	    logo.setFocusable(false);
	    logo.setOnClickListener(new BeemConnectionOnClick());
	    TextView name = (TextView) v.findViewById(R.id.accountname);
	    name.setText(mListAccount.get(position));
	    return v;
	}

    }

    private class BeemConnectionOnClick implements android.view.View.OnClickListener {

	@Override
	public void onClick(View v) {
	    //TODO: Check if already connected -> disconnect
	    TextView accountStatus = (TextView) findViewById(R.id.accountstatus);
	    accountStatus.setText(R.string.login_pending);    
	    ImageButton logo = (ImageButton) findViewById(R.id.loginanim_logo_anim);
	    logo.startAnimation(mAnimationLogo);
	    TextView accountName = (TextView) findViewById(R.id.accountname);
	    Intent i = new Intent(Login.SERVICE_INTENT);
	    i.putExtra("account_name", accountName.getText());
	    bindService(i, mServConn, BIND_AUTO_CREATE);
	    mTask = new LoginTask(v.getRootView());

	}

    }

    /**
     * Event simple click on item of the contact list.
     */
    private class BeemAccountListOnClick implements OnItemClickListener {
	/**
	 * Constructor.
	 */
	public BeemAccountListOnClick() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onItemClick(AdapterView<?> arg0, View v, int pos, long lpos) {
	    Intent i = new Intent(Login.this, ContactList.class);
	    startActivity(i);
	}
    }

    /**
     * Asynchronous class for connection.
     */
    private class LoginTask extends LoginAsyncTask {

	private View mView;

	/**
	 * Constructor.
	 */
	LoginTask(View v) {
	    mView = v;
	}

	@Override
	protected void onPostExecute(Boolean result) {
	    ImageButton logo = (ImageButton) mView.findViewById(R.id.loginanim_logo_anim);
	    if (result == null || !result) { // Task cancelled or exception
		unbindService(mServConn);
		logo.setBackgroundResource(R.drawable.beem_launcher_icon_silver);
	    } else { // Connection OK
		logo.setBackgroundResource(R.drawable.beem_icon_launcher_color);
	    }
	    logo.clearAnimation();
	}

	@Override
	protected void onProgressUpdate(Integer... values) {
	    TextView status = (TextView) mView.findViewById(R.id.accountstatus);
	    status.setText(getResources().getStringArray(R.array.loganim_state)[values[0]]);
	}

	@Override
	protected void onCancelled() {
	    super.onCancelled();
	    Login.this.stopService(Login.SERVICE_INTENT);
	}

    }

    /**
     * The service connection used to connect to the Beem service.
     */
    private class LoginServiceConnection implements ServiceConnection {

	/**
	 * Constructor.
	 */
	public LoginServiceConnection() {
	}

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    Log.e("BEEMSERVICECONNECTION", "CONNECTED");
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);	    
	    mTask.execute(mXmppFacade);
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    Log.e("BEEMSERVICECONNECTION", "DISCONNECTED");
	    mXmppFacade = null;
	}
    }

}
