/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DirectiveList;
import com.novell.sasl.client.ParsedDirective;
import com.novell.sasl.client.TokenParser;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.harmony.javax.security.sasl.SaslException;

class DigestChallenge {
    public static final int QOP_AUTH = 1;
    public static final int QOP_AUTH_INT = 2;
    public static final int QOP_AUTH_CONF = 4;
    public static final int QOP_UNRECOGNIZED = 8;
    private static final int CIPHER_3DES = 1;
    private static final int CIPHER_DES = 2;
    private static final int CIPHER_RC4_40 = 4;
    private static final int CIPHER_RC4 = 8;
    private static final int CIPHER_RC4_56 = 16;
    private static final int CIPHER_UNRECOGNIZED = 32;
    private static final int CIPHER_RECOGNIZED_MASK = 31;
    private ArrayList m_realms = new ArrayList(5);
    private String m_nonce = null;
    private int m_qop = 0;
    private boolean m_staleFlag = false;
    private int m_maxBuf = -1;
    private String m_characterSet = null;
    private String m_algorithm = null;
    private int m_cipherOptions = 0;

    DigestChallenge(byte[] byArray) throws SaslException {
        DirectiveList directiveList = new DirectiveList(byArray);
        try {
            directiveList.parseDirectives();
            this.checkSemantics(directiveList);
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    void checkSemantics(DirectiveList directiveList) throws SaslException {
        Iterator iterator = directiveList.getIterator();
        while (iterator.hasNext()) {
            ParsedDirective parsedDirective = (ParsedDirective)iterator.next();
            String string = parsedDirective.getName();
            if (string.equals("realm")) {
                this.handleRealm(parsedDirective);
                continue;
            }
            if (string.equals("nonce")) {
                this.handleNonce(parsedDirective);
                continue;
            }
            if (string.equals("qop")) {
                this.handleQop(parsedDirective);
                continue;
            }
            if (string.equals("maxbuf")) {
                this.handleMaxbuf(parsedDirective);
                continue;
            }
            if (string.equals("charset")) {
                this.handleCharset(parsedDirective);
                continue;
            }
            if (string.equals("algorithm")) {
                this.handleAlgorithm(parsedDirective);
                continue;
            }
            if (string.equals("cipher")) {
                this.handleCipher(parsedDirective);
                continue;
            }
            if (!string.equals("stale")) continue;
            this.handleStale(parsedDirective);
        }
        if (-1 == this.m_maxBuf) {
            this.m_maxBuf = 65536;
        }
        if (this.m_qop == 0) {
            this.m_qop = 1;
        } else {
            if ((this.m_qop & 1) != 1) {
                throw new SaslException("Only qop-auth is supported by client");
            }
            if ((this.m_qop & 4) == 4 && 0 == (this.m_cipherOptions & 0x1F)) {
                throw new SaslException("Invalid cipher options");
            }
            if (null == this.m_nonce) {
                throw new SaslException("Missing nonce directive");
            }
            if (this.m_staleFlag) {
                throw new SaslException("Unexpected stale flag");
            }
            if (null == this.m_algorithm) {
                throw new SaslException("Missing algorithm directive");
            }
        }
    }

    void handleNonce(ParsedDirective parsedDirective) throws SaslException {
        if (null != this.m_nonce) {
            throw new SaslException("Too many nonce values.");
        }
        this.m_nonce = parsedDirective.getValue();
    }

    void handleRealm(ParsedDirective parsedDirective) {
        this.m_realms.add(parsedDirective.getValue());
    }

    void handleQop(ParsedDirective parsedDirective) throws SaslException {
        if (this.m_qop != 0) {
            throw new SaslException("Too many qop directives.");
        }
        TokenParser tokenParser = new TokenParser(parsedDirective.getValue());
        String string = tokenParser.parseToken();
        while (string != null) {
            this.m_qop = string.equals("auth") ? (this.m_qop |= 1) : (string.equals("auth-int") ? (this.m_qop |= 2) : (string.equals("auth-conf") ? (this.m_qop |= 4) : (this.m_qop |= 8)));
            string = tokenParser.parseToken();
        }
    }

    void handleMaxbuf(ParsedDirective parsedDirective) throws SaslException {
        if (-1 != this.m_maxBuf) {
            throw new SaslException("Too many maxBuf directives.");
        }
        this.m_maxBuf = Integer.parseInt(parsedDirective.getValue());
        if (0 == this.m_maxBuf) {
            throw new SaslException("Max buf value must be greater than zero.");
        }
    }

    void handleCharset(ParsedDirective parsedDirective) throws SaslException {
        if (null != this.m_characterSet) {
            throw new SaslException("Too many charset directives.");
        }
        this.m_characterSet = parsedDirective.getValue();
        if (!this.m_characterSet.equals("utf-8")) {
            throw new SaslException("Invalid character encoding directive");
        }
    }

    void handleAlgorithm(ParsedDirective parsedDirective) throws SaslException {
        if (null != this.m_algorithm) {
            throw new SaslException("Too many algorithm directives.");
        }
        this.m_algorithm = parsedDirective.getValue();
        if (!"md5-sess".equals(this.m_algorithm)) {
            throw new SaslException("Invalid algorithm directive value: " + this.m_algorithm);
        }
    }

    void handleCipher(ParsedDirective parsedDirective) throws SaslException {
        if (0 != this.m_cipherOptions) {
            throw new SaslException("Too many cipher directives.");
        }
        TokenParser tokenParser = new TokenParser(parsedDirective.getValue());
        String string = tokenParser.parseToken();
        string = tokenParser.parseToken();
        while (string != null) {
            this.m_cipherOptions = "3des".equals(string) ? (this.m_cipherOptions |= 1) : ("des".equals(string) ? (this.m_cipherOptions |= 2) : ("rc4-40".equals(string) ? (this.m_cipherOptions |= 4) : ("rc4".equals(string) ? (this.m_cipherOptions |= 8) : ("rc4-56".equals(string) ? (this.m_cipherOptions |= 0x10) : (this.m_cipherOptions |= 0x20)))));
            string = tokenParser.parseToken();
        }
        if (this.m_cipherOptions == 0) {
            this.m_cipherOptions = 32;
        }
    }

    void handleStale(ParsedDirective parsedDirective) throws SaslException {
        if (this.m_staleFlag) {
            throw new SaslException("Too many stale directives.");
        }
        if (!"true".equals(parsedDirective.getValue())) {
            throw new SaslException("Invalid stale directive value: " + parsedDirective.getValue());
        }
        this.m_staleFlag = true;
    }

    public ArrayList getRealms() {
        return this.m_realms;
    }

    public String getNonce() {
        return this.m_nonce;
    }

    public int getQop() {
        return this.m_qop;
    }

    public boolean getStaleFlag() {
        return this.m_staleFlag;
    }

    public int getMaxBuf() {
        return this.m_maxBuf;
    }

    public String getCharacterSet() {
        return this.m_characterSet;
    }

    public String getAlgorithm() {
        return this.m_algorithm;
    }

    public int getCipherOptions() {
        return this.m_cipherOptions;
    }
}

